/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.data.item;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.web.toolkit.client.common.json.JSonSerializer;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.IItem;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ItemAttribute;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ModifierEngine;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ValidatorEngine;
import org.bonitasoft.web.toolkit.client.data.item.template.ItemHasDualDescription;
import org.bonitasoft.web.toolkit.client.data.item.template.ItemHasDualName;
import org.bonitasoft.web.toolkit.client.data.item.template.ItemHasUniqueId;
import org.bonitasoft.web.toolkit.client.ui.utils.DateFormat;

public abstract class Item
implements IItem {
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final Map<String, IItem> deploys = new HashMap<String, IItem>();
    private static boolean applyOutputModifiersByDefault = true;
    private static boolean applyInputModifiersByDefault = true;
    private static boolean applyValidatorsByDefault = true;
    private static boolean applyValidatorMandatoryByDefault = true;
    private Boolean applyOutputModifiers = null;
    private Boolean applyInputModifiers = null;
    private Boolean applyValidators = null;
    private Boolean applyValidatorMandatory = null;

    public Item() {
    }

    public Item(IItem item) {
        this.attributes.putAll(item.getAttributes());
    }

    @Override
    public List<String> getAPIIDOrder() {
        return this.getItemDefinition().getPrimaryKeys();
    }

    @Override
    public final void setId(APIID id) {
        this.setAttribute("id", id);
    }

    @Override
    public APIID getId() {
        APIID apiid = null;
        ItemDefinition<?> itemDefinition = this.getItemDefinition();
        if (this instanceof ItemHasUniqueId) {
            apiid = this.getAttributeValueAsAPIID("id");
        } else {
            ArrayList<String> primaryKeysValues = new ArrayList<String>();
            ArrayList<String> primaryKeys = itemDefinition.getPrimaryKeys();
            if (primaryKeys.isEmpty()) {
                primaryKeys.add("id");
            }
            for (String key : primaryKeys) {
                primaryKeysValues.add(this.getAttributeValue(key));
            }
            apiid = APIID.makeAPIID(primaryKeysValues);
        }
        apiid.setItemDefinition(itemDefinition);
        return apiid;
    }

    public static void setApplyOutputModifiersByDefault(boolean applyOutputModifiersByDefault) {
        Item.applyOutputModifiersByDefault = applyOutputModifiersByDefault;
    }

    public static void setApplyInputModifiersByDefault(boolean applyInputModifiersByDefault) {
        Item.applyInputModifiersByDefault = applyInputModifiersByDefault;
    }

    public static void setApplyValidatorsByDefault(boolean applyValidatorsByDefault) {
        Item.applyValidatorsByDefault = applyValidatorsByDefault;
    }

    public static void setApplyValidatorMandatoryByDefault(boolean applyValidatorMandatoryByDefault) {
        Item.applyValidatorMandatoryByDefault = applyValidatorMandatoryByDefault;
    }

    @Override
    public final void setApplyOutputModifiers(boolean applyOutputModifiers) {
        this.applyOutputModifiers = applyOutputModifiers;
    }

    @Override
    public final void setApplyInputModifiers(boolean applyInputModifiers) {
        this.applyInputModifiers = applyInputModifiers;
    }

    @Override
    public final void setApplyValidators(boolean applyValidators) {
        this.applyValidators = applyValidators;
    }

    @Override
    public final void setApplyValidatorMandatory(boolean applyValidatorMandatory) {
        this.applyValidatorMandatory = applyValidatorMandatory;
    }

    @Override
    public void setAttribute(String name, String value) {
        this.setAttribute(name, value, this.applyInputModifiers == null ? applyInputModifiersByDefault : this.applyInputModifiers, this.applyValidators == null ? applyValidatorsByDefault : this.applyValidators);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value != null ? value.toString() : null);
    }

    @Override
    public final void setAttribute(String name, Date value) {
        this.setAttribute(name, DateFormat.dateToSql(value));
    }

    @Override
    public final void setAttribute(String name, APIID value) {
        if (value != null) {
            this.setAttribute(name, value.toString());
        } else {
            this.setAttribute(name, (String)null);
        }
    }

    @Override
    public final void setAttribute(String name, String value, boolean applyModifiers, boolean applyValidators) {
        ItemAttribute attribute = this.getItemDefinition().getAttribute(name);
        String realValue = value;
        if (attribute != null && applyModifiers) {
            realValue = ModifierEngine.modify(realValue, attribute.getInputModifiers());
        }
        this.attributes.put(name, realValue);
        if (applyValidators) {
            ValidatorEngine.validate(this, this.applyValidatorMandatory == null ? applyValidatorMandatoryByDefault : this.applyValidatorMandatory);
        }
    }

    @Override
    public final void setAttribute(String name, Object value, boolean applyModifiers, boolean applyValidators) {
        if (value != null) {
            this.setAttribute(name, value.toString(), applyModifiers, applyValidators);
        } else {
            this.setAttribute(name, (String)null, applyModifiers, applyValidators);
        }
    }

    @Override
    public final void setAttribute(String name, APIID value, boolean applyModifiers, boolean applyValidators) {
        if (value != null) {
            this.setAttribute(name, value.toString(), applyModifiers, applyValidators);
        } else {
            this.setAttribute(name, (String)null, applyModifiers, applyValidators);
        }
    }

    @Override
    public final void setAttribute(String name, Date value, boolean applyModifiers, boolean applyValidators) {
        this.setAttribute(name, DateFormat.dateToSql(value), applyModifiers, applyValidators);
    }

    @Override
    public void setDeploy(String attributeName, IItem item) {
        this.deploys.put(attributeName, item);
    }

    @Override
    public final void removeDeploy(String attributeName) {
        this.deploys.remove(attributeName);
    }

    @Override
    public final boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public final boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    @Override
    public final String getAttributeValue(String attributeName, boolean applyModifiers) {
        String[] splittedAttribute = attributeName.split("\\.");
        if (splittedAttribute.length == 2) {
            IItem deploy = this.getDeploy(splittedAttribute[0]);
            return deploy.getAttributeValue(splittedAttribute[1]);
        }
        if (this.deploys.containsKey(attributeName)) {
            IItem deploy = this.getDeploy(attributeName);
            if (deploy == null) {
                return null;
            }
            return deploy.getId().toString();
        }
        String realValue = this.attributes.get(attributeName);
        if (this instanceof ItemHasDualName) {
            if ("displayName".equals(attributeName) && StringUtil.isBlank(realValue)) {
                realValue = this.getAttributeValue("name");
            }
        } else if (this instanceof ItemHasDualDescription && "displayDescription".equals(attributeName) && StringUtil.isBlank(realValue)) {
            realValue = this.getAttributeValue("description");
        }
        return realValue;
    }

    @Override
    public String getAttributeValue(String attributeName) {
        return this.getAttributeValue(attributeName, this.applyOutputModifiers == null ? applyOutputModifiersByDefault : this.applyOutputModifiers);
    }

    @Override
    public final String getAttributeValue(ItemAttribute itemAttribute) {
        return this.getAttributeValue(itemAttribute.getName(), this.applyOutputModifiers == null ? applyOutputModifiersByDefault : this.applyOutputModifiers);
    }

    @Override
    public final String getAttributeValue(ItemAttribute itemAttribute, boolean applyModifiers) {
        return this.getAttributeValue(itemAttribute.getName(), applyModifiers);
    }

    @Override
    public final APIID getAttributeValueAsAPIID(String attributeName, boolean applyModifiers) {
        return APIID.makeAPIID(this.getAttributeValue(attributeName, applyModifiers));
    }

    @Override
    public final APIID getAttributeValueAsAPIID(String attributeName) {
        return APIID.makeAPIID(this.getAttributeValue(attributeName));
    }

    @Override
    public final APIID getAttributeValueAsAPIID(ItemAttribute itemAttribute, boolean applyModifiers) {
        return APIID.makeAPIID(this.getAttributeValue(itemAttribute, applyModifiers));
    }

    @Override
    public final APIID getAttributeValueAsAPIID(ItemAttribute itemAttribute) {
        return APIID.makeAPIID(this.getAttributeValue(itemAttribute));
    }

    @Override
    public final Date getAttributeValueAsDate(String attributeName, boolean applyModifiers) {
        return DateFormat.sqlToDate(this.getAttributeValue(attributeName, applyModifiers));
    }

    @Override
    public final Date getAttributeValueAsDate(String attributeName) {
        return DateFormat.sqlToDate(this.getAttributeValue(attributeName));
    }

    @Override
    public final Date getAttributeValueAsDate(ItemAttribute itemAttribute, boolean applyModifiers) {
        return DateFormat.sqlToDate(this.getAttributeValue(itemAttribute, applyModifiers));
    }

    @Override
    public final Date getAttributeValueAsDate(ItemAttribute itemAttribute) {
        return DateFormat.sqlToDate(this.getAttributeValue(itemAttribute));
    }

    public final Long getAttributeValueAsLong(String attributeName, boolean applyModifiers) {
        return Long.valueOf(this.getAttributeValue(attributeName, applyModifiers));
    }

    public final Long getAttributeValueAsLong(String attributeName) {
        return Long.valueOf(this.getAttributeValue(attributeName));
    }

    public final Long getAttributeValueAsLong(ItemAttribute itemAttribute, boolean applyModifiers) {
        return Long.valueOf(this.getAttributeValue(itemAttribute, applyModifiers));
    }

    public final Long getAttributeValueAsLong(ItemAttribute itemAttribute) {
        return Long.valueOf(this.getAttributeValue(itemAttribute));
    }

    @Override
    public final Map<String, String> getAttributes() {
        return this.getAttributes(this.applyOutputModifiers == null ? applyOutputModifiersByDefault : this.applyOutputModifiers);
    }

    @Override
    public final Map<String, String> getAttributes(boolean applyModifiers) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (String attributeName : this.attributes.keySet()) {
            results.put(attributeName, this.getAttributeValue(attributeName, applyModifiers));
        }
        return results;
    }

    @Override
    public final IItem getDeploy(String attributeName) {
        return this.deploys.get(attributeName);
    }

    @Override
    public Map<String, IItem> getDeploys() {
        return this.deploys;
    }

    @Override
    public final ArrayList<String> getAttributeNames() {
        return new ArrayList<String>(this.attributes.keySet());
    }

    @Override
    public final void setAttributes(Map<String, String> attributes, boolean applyModifiers, boolean applyValidators) {
        if (attributes == null || attributes.size() == 0) {
            return;
        }
        for (String attributeName : attributes.keySet()) {
            this.setAttribute(attributeName, attributes.get(attributeName), applyModifiers, false);
        }
        if (applyValidators) {
            ValidatorEngine.validate(this);
        }
    }

    @Override
    public final void setAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes, this.applyInputModifiers == null ? applyInputModifiersByDefault : this.applyInputModifiers, this.applyValidators == null ? applyValidatorsByDefault : this.applyValidators);
    }

    @Override
    public abstract ItemDefinition<?> getItemDefinition();

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        for (String string : this.attributes.keySet()) {
            String rawValue = this.attributes.get(string);
            String cleanValue = this.getAttributeValue(string);
            sb.append(string).append(" : ").append(rawValue);
            if (rawValue != null && !rawValue.equals(cleanValue)) {
                sb.append(" >> ").append(cleanValue);
            }
            sb.append("\r\n");
        }
        for (Map.Entry entry : this.deploys.entrySet()) {
            sb.append((String)entry.getKey()).append(" : ").append(entry.getValue());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    @Override
    public final String toJson() {
        StringBuilder json = new StringBuilder().append("{");
        boolean first = true;
        for (String attribute : this.getAttributeNames()) {
            if (this.deploys.containsKey(attribute)) {
                json.append(!first ? "," : "").append(JSonSerializer.quote(attribute)).append(":").append(JSonSerializer.serialize(this.deploys.get(attribute)));
            } else {
                json.append(!first ? "," : "").append(JSonSerializer.quote(attribute)).append(":").append(JSonSerializer.quote(this.getAttributeValue(attribute)));
            }
            first = false;
        }
        json.append("}");
        return json.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.applyInputModifiers == null ? 0 : this.applyInputModifiers.hashCode());
        result = 31 * result + (this.applyOutputModifiers == null ? 0 : this.applyOutputModifiers.hashCode());
        result = 31 * result + (this.applyValidatorMandatory == null ? 0 : this.applyValidatorMandatory.hashCode());
        result = 31 * result + (this.applyValidators == null ? 0 : this.applyValidators.hashCode());
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.deploys == null ? 0 : this.deploys.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Item other = (Item)obj;
        if (this.applyInputModifiers == null ? other.applyInputModifiers != null : !this.applyInputModifiers.equals(other.applyInputModifiers)) {
            return false;
        }
        if (this.applyOutputModifiers == null ? other.applyOutputModifiers != null : !this.applyOutputModifiers.equals(other.applyOutputModifiers)) {
            return false;
        }
        if (this.applyValidatorMandatory == null ? other.applyValidatorMandatory != null : !this.applyValidatorMandatory.equals(other.applyValidatorMandatory)) {
            return false;
        }
        if (this.applyValidators == null ? other.applyValidators != null : !this.applyValidators.equals(other.applyValidators)) {
            return false;
        }
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.deploys == null) {
            return other.deploys == null;
        }
        return this.deploys.equals(other.deploys);
    }
}

