/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.data.item.attribute;

import java.util.LinkedList;
import java.util.List;
import org.bonitasoft.web.toolkit.client.data.item.attribute.Validable;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.Validator;
import org.bonitasoft.web.toolkit.client.ui.utils.ListUtils;

public class ValidatorsList
implements Validable {
    private final List<Validator> validators = new LinkedList<Validator>();

    @Override
    public List<Validator> getValidators() {
        return this.validators;
    }

    @Override
    public ValidatorsList addValidator(Validator validator) {
        ListUtils.removeFromListByClass(this.validators, validator.getClass().getName(), true);
        this.validators.add(validator);
        return this;
    }

    @Override
    public ValidatorsList addValidators(List<Validator> validators) {
        for (Validator validator : validators) {
            this.addValidator(validator);
        }
        return this;
    }

    @Override
    public ValidatorsList removeValidator(String validatorClassName) {
        ListUtils.removeFromListByClass(this.validators, validatorClassName);
        return this;
    }

    @Override
    public boolean hasValidator(String validatorClassName) {
        return this.getValidator(validatorClassName) != null;
    }

    @Override
    public Validator getValidator(String validatorClassName) {
        return (Validator)ListUtils.getFromListByClass(this.validators, validatorClassName);
    }
}

