/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.ui.utils;

import java.util.Date;
import org.bonitasoft.web.toolkit.client.common.CommonDateFormater;
import org.bonitasoft.web.toolkit.client.common.i18n.AbstractI18n;

public abstract class DateFormat {
    public static Date formatToDate(String date, FORMAT format) throws IllegalArgumentException {
        if (date == null) {
            return null;
        }
        if (format.equals((Object)FORMAT.LONG)) {
            new Date(Long.parseLong(date));
        }
        return DateFormat.formatToDate(date, format.getFormatString());
    }

    public static Date formatToDate(String date, String format) throws IllegalArgumentException {
        if (date == null) {
            return null;
        }
        return CommonDateFormater.parse(date, format);
    }

    public static Long formatToLong(String date, FORMAT format) throws IllegalArgumentException {
        if (date == null || date.isEmpty()) {
            return null;
        }
        if (format.equals((Object)FORMAT.LONG)) {
            return Long.parseLong(date);
        }
        return DateFormat.formatToLong(date, format.getFormatString());
    }

    public static Long formatToLong(String date, String format) throws IllegalArgumentException {
        if (date == null) {
            return null;
        }
        Date _date = CommonDateFormater.parse(date, format);
        return _date.getTime();
    }

    public static String dateToFormat(Date date, String format) {
        if (date == null) {
            return null;
        }
        return CommonDateFormater.toString(date, format);
    }

    public static String dateToSql(Date date) {
        return DateFormat.dateToFormat(date, FORMAT.SQL.getFormatString());
    }

    public static Long sqlToLong(String date) {
        return DateFormat.formatToLong(date, FORMAT.SQL);
    }

    public static Date sqlToDate(String date) {
        return DateFormat.formatToDate(date, FORMAT.SQL);
    }

    public static enum FORMAT {
        SQL("yyyy-MM-dd HH:mm:ss.SSS"),
        FORM(AbstractI18n.t_("MM/dd/yyyy")),
        DISPLAY(AbstractI18n.t_("MM/dd/yyyy h:mm a")),
        DISPLAY_SHORT(AbstractI18n.t_("MMMM dd, yyyy")),
        LONG,
        DISPLAY_RELATIVE;

        private final String formatString;

        private FORMAT() {
            this("");
        }

        private FORMAT(String formatString) {
            this.formatString = formatString;
        }

        public String getFormatString() {
            return this.formatString;
        }
    }

    public static enum UNIT {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND;

    }
}

