/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.server.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.console.common.server.utils.LocaleUtils;
import org.bonitasoft.web.rest.server.framework.json.JSonSimpleDeserializer;
import org.bonitasoft.web.toolkit.client.common.CommonDateFormater;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIForbiddenException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIIncorrectIdException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemIdMalformedException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIMethodNotAllowedException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APINotFoundException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APITooManyRequestException;
import org.bonitasoft.web.toolkit.client.common.i18n.AbstractI18n;
import org.bonitasoft.web.toolkit.client.common.json.JSonItemReader;
import org.bonitasoft.web.toolkit.client.common.json.JSonSerializer;
import org.bonitasoft.web.toolkit.client.data.item.Item;
import org.bonitasoft.web.toolkit.server.ServiceException;
import org.bonitasoft.web.toolkit.server.ServiceNotFoundException;
import org.bonitasoft.web.toolkit.server.ServletCall;
import org.bonitasoft.web.toolkit.server.utils.ServerDateFormater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ToolkitHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = -8470006030459575773L;
    public static final DateTimeFormatter RFC1123_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US).withZone(ZoneId.of("GMT"));
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)ToolkitHttpServlet.class.getName());

    public ToolkitHttpServlet() {
        this.initializeToolkit();
    }

    protected final void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            super.service(req, resp);
        }
        catch (Exception e) {
            this.catchAllExceptions(this.retrieveLowestAPIException(e), req, resp);
        }
    }

    private Throwable retrieveLowestAPIException(Throwable e) {
        Throwable lowest = e;
        while (lowest.getCause() != null && lowest.getCause() instanceof APIException) {
            lowest = lowest.getCause();
        }
        return lowest;
    }

    protected final void outputException(Throwable e, HttpServletRequest req, HttpServletResponse resp, int httpStatusCode) {
        if (httpStatusCode >= 0) {
            resp.setStatus(httpStatusCode);
        }
        resp.setContentType("application/json;charset=UTF-8");
        try {
            PrintWriter output = resp.getWriter();
            if (e instanceof APIException) {
                APIException apiException = (APIException)e;
                this.setLocalization(apiException, LocaleUtils.getUserLocaleAsString(req));
            }
            output.print(e == null ? "" : JSonSerializer.serialize(e));
            output.flush();
        }
        catch (Exception e2) {
            throw new APIException(e2);
        }
    }

    protected final void outputException(Throwable e, HttpServletRequest req, HttpServletResponse resp, int httpStatusCode, Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            resp.addHeader(header.getKey(), header.getValue());
        }
        this.outputException(e, req, resp, httpStatusCode);
    }

    protected final void outputException(Throwable e, HttpServletRequest req, HttpServletResponse resp) {
        this.outputException(e, req, resp, -1);
    }

    private void setLocalization(APIException localizable, String locale) {
        if (locale != null && !locale.isEmpty()) {
            localizable.setLocale(AbstractI18n.LOCALE.valueOf(locale));
        }
    }

    protected void initializeToolkit() {
        Item.setApplyInputModifiersByDefault(false);
        Item.setApplyValidatorsByDefault(false);
        Item.setApplyOutputModifiersByDefault(false);
        Item.setApplyValidatorMandatoryByDefault(false);
        CommonDateFormater.setDateFormater(new ServerDateFormater());
        JSonItemReader.setUnserializer(new JSonSimpleDeserializer());
    }

    protected void catchAllExceptions(Throwable exception, HttpServletRequest req, HttpServletResponse resp) {
        if (exception instanceof APIMethodNotAllowedException) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(exception.getMessage(), exception);
            }
            this.outputException(exception, req, resp, 405);
        } else if (exception instanceof APINotFoundException || exception instanceof ServiceNotFoundException) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(exception.getMessage(), exception);
            }
            this.outputException(exception, req, resp, 404);
        } else if (exception instanceof APIItemNotFoundException) {
            LOGGER.debug(exception.getMessage(), exception);
            this.outputException(null, req, resp, 404);
        } else if (exception instanceof APIForbiddenException) {
            this.outputException(exception, req, resp, 403);
        } else if (exception instanceof ServiceException) {
            if (resp.getStatus() < 400) {
                this.outputException(exception, req, resp, 500);
            } else {
                this.outputException(exception, req, resp);
            }
        } else if (exception instanceof APIIncorrectIdException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(exception.getMessage(), exception);
            }
            this.outputException(exception, req, resp, 400);
        } else if (exception instanceof APIItemIdMalformedException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(exception.getMessage(), exception);
            }
            this.outputException(exception, req, resp, 500);
        } else if (exception instanceof APITooManyRequestException) {
            APITooManyRequestException ex = (APITooManyRequestException)exception;
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(exception.getMessage(), exception);
            }
            Map<String, String> headers = Map.of("Retry-After", RFC1123_DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(ex.getRetryAfter())));
            this.outputException(exception, req, resp, ex.getStatusCode(), headers);
        } else {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(exception.getMessage(), exception);
            }
            this.outputException(exception, req, resp, 500);
        }
    }

    protected abstract ServletCall defineServletCall(HttpServletRequest var1, HttpServletResponse var2);

    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.defineServletCall(req, resp).doGet();
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.defineServletCall(req, resp).doPost();
    }

    protected final void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.defineServletCall(req, resp).doPut();
    }

    protected final void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.defineServletCall(req, resp).doDelete();
    }

    protected final long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }

    protected final void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    protected final void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    protected final void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doTrace(req, resp);
    }

    public final void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }
}

