/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.auth;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.BooleanUtils;
import org.bonitasoft.console.common.server.preferences.properties.ConfigurationFile;

public class AuthenticationManagerProperties
extends ConfigurationFile {
    protected static final String AUTHENTICATION_CONFIG_FILE_NAME = "authenticationManager-config.properties";
    public static final String LOGOUT_DISABLED = "logout.link.hidden";
    protected static final String AUTHENTICATION_MANAGER = "auth.AuthenticationManager";
    protected static final String OAUTH_SERVICE_PROVIDER = "OAuth.serviceProvider";
    protected static final String OAUTH_CONSUMER_KEY = "OAuth.consumerKey";
    protected static final String OAUTH_CONSUMER_SECRET = "OAuth.consumerSecret";
    protected static final String OAUTH_CALLBACK_URL = "OAuth.callbackURL";
    protected static final String CAS_SERVER_URL = "Cas.serverUrlPrefix";
    protected static final String CAS_BONITA_SERVICE_URL = "Cas.bonitaServiceURL";
    private static final Map<String, Optional<String>> authenticationProperties = new ConcurrentHashMap<String, Optional<String>>();

    public AuthenticationManagerProperties() {
        super(AUTHENTICATION_CONFIG_FILE_NAME);
    }

    public static AuthenticationManagerProperties getProperties() {
        return new AuthenticationManagerProperties();
    }

    public String getAuthenticationManagerImpl() {
        return this.getTenantProperty(AUTHENTICATION_MANAGER);
    }

    public String getOAuthServiceProviderName() {
        return this.getTenantProperty(OAUTH_SERVICE_PROVIDER);
    }

    public String getOAuthConsumerKey() {
        return this.getTenantProperty(OAUTH_CONSUMER_KEY);
    }

    public String getOAuthConsumerSecret() {
        return this.getTenantProperty(OAUTH_CONSUMER_SECRET);
    }

    public String getOAuthCallbackURL() {
        return this.getTenantProperty(OAUTH_CALLBACK_URL);
    }

    public String getCasServerURL() {
        return this.getTenantProperty(CAS_SERVER_URL);
    }

    public String getCasBonitaServiceUrl() {
        return this.getTenantProperty(CAS_BONITA_SERVICE_URL);
    }

    public boolean isLogoutDisabled() {
        return BooleanUtils.toBoolean((String)this.getTenantProperty(LOGOUT_DISABLED));
    }

    @Override
    public String getTenantProperty(String propertyName) {
        Optional<String> propertyValue = authenticationProperties.get(propertyName);
        if (propertyValue == null) {
            propertyValue = Optional.ofNullable(super.getTenantProperty(propertyName));
            authenticationProperties.put(propertyName, propertyValue);
        }
        return propertyValue.orElse(null);
    }
}

