/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.auth.impl.jaas;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.bonitasoft.console.common.server.utils.TenantsManagementUtils;

public class ConsoleCallbackHandler
implements CallbackHandler {
    private final String name;
    private final String password;

    public ConsoleCallbackHandler(String name, String password) {
        this.name = name;
        this.password = password;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback;
                nc.setName(this.name);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callback;
                pc.setPassword(this.password.toCharArray());
                continue;
            }
            if (!(callback instanceof TextInputCallback)) continue;
            TextInputCallback tc = (TextInputCallback)callback;
            tc.setText(String.valueOf(TenantsManagementUtils.getDefaultTenantId()));
        }
    }
}

