/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.i18n;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bonitasoft.console.common.server.i18n.FileUtils;
import org.bonitasoft.console.common.server.i18n.POParser;
import org.bonitasoft.web.toolkit.client.common.i18n.AbstractI18n;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class I18n
extends AbstractI18n {
    public static final String I18N_CUSTOM_DIR_PROPERTY = "org.bonitasoft.i18n.folder";
    private static File I18N_CUSTOM_DIR = I18n.getI18nCustomDirectory();

    private I18n() {
    }

    public static I18n getInstance() {
        if (I18N_instance == null) {
            I18N_instance = new I18n();
        }
        return (I18n)I18N_instance;
    }

    public static void setInstance(I18n instance) {
        I18N_instance = instance;
    }

    public void refresh() {
        I18N_CUSTOM_DIR = I18n.getI18nCustomDirectory();
    }

    private static File getI18nCustomDirectory() {
        String customI18nFolder = System.getProperty(I18N_CUSTOM_DIR_PROPERTY);
        return customI18nFolder != null ? new File(customI18nFolder) : null;
    }

    @Override
    public void loadLocale(AbstractI18n.LOCALE locale) {
        Map<String, String> results = this.loadLocale(this.getStreams(locale));
        if (I18N_CUSTOM_DIR != null) {
            results.putAll(this.loadLocale(locale, FileUtils.listDir(I18N_CUSTOM_DIR)));
        }
        this.setLocale(locale, results);
    }

    private Map<String, String> loadLocale(List<InputStream> streams) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (InputStream stream : streams) {
            treeMap.putAll(this.parsePoResource(stream));
        }
        return treeMap;
    }

    private TreeMap<String, String> loadLocale(AbstractI18n.LOCALE locale, List<File> files) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (File file : this.getLocaleFiles(locale, files)) {
            treeMap.putAll(this.parsePoFile(file));
        }
        return treeMap;
    }

    public List<InputStream> getStreams(AbstractI18n.LOCALE locale) {
        PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = patternResolver.getResources("classpath*:i18n/" + this.getLocaleRegexForResource(locale));
            ArrayList<InputStream> streams = new ArrayList<InputStream>(resources.length);
            for (Resource resource : resources) {
                InputStream stream = resource.getInputStream();
                streams.add(stream);
            }
            return streams;
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private Map<String, String> parsePoFile(File file) {
        return POParser.parse(file);
    }

    private Map<String, String> parsePoResource(InputStream stream) {
        return POParser.parsePOFromStream(stream);
    }

    private List<File> getLocaleFiles(AbstractI18n.LOCALE locale, List<File> files) {
        return FileUtils.getMatchingFiles(this.makeLocaleRegex(locale), files);
    }

    private String makeLocaleRegex(AbstractI18n.LOCALE locale) {
        return "(.*)" + locale.toString().trim() + ".po";
    }

    private String getLocaleRegexForResource(AbstractI18n.LOCALE locale) {
        return "*" + locale.toString().trim() + ".po";
    }

    public Map<String, String> getAvailableLocalesFor(String application) {
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        Map<String, String> locales = I18n.getLocales();
        results.put("en", "English");
        for (String locale : locales.keySet()) {
            if (!I18n.localeExists(locale, application)) continue;
            results.put(locale, locales.get(locale));
        }
        return results;
    }

    private static boolean localeExists(String locale, String application) {
        String fileName = application + "_" + locale + ".po";
        File file = new File(I18N_CUSTOM_DIR, fileName);
        return file.exists() || I18n.class.getResource("/i18n/" + fileName) != null;
    }

    @Override
    protected String getText(String string) {
        return string;
    }

    @Override
    protected String getText(String string, Arg ... args) {
        return string;
    }
}

