/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.i18n;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import org.fedorahosted.tennera.jgettext.Catalog;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.PoParser;
import org.fedorahosted.tennera.jgettext.catalog.parse.ParseException;

public class POParser {
    private final Map<String, String> translations = new TreeMap<String, String>();

    private POParser() {
    }

    public static Map<String, String> parse(File file) {
        return new POParser().parseFile(file);
    }

    private Map<String, String> parseFile(File file) {
        try {
            this.parseCatalog(new PoParser().parseCatalog(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("I18N: File not found " + file.getPath());
        }
        catch (ParseException e) {
            throw new RuntimeException("I18N: Could not parse po file " + file.getPath());
        }
        catch (IOException e) {
            throw new RuntimeException("I18N: IO issues while parsing " + file.getPath());
        }
        return this.translations;
    }

    public static Map<String, String> parsePOFromStream(InputStream stream) {
        return new POParser().parseFromStream(stream);
    }

    private Map<String, String> parseFromStream(InputStream stream) {
        try {
            this.parseCatalog(new PoParser().parseCatalog(stream, false));
        }
        catch (IOException e) {
            throw new RuntimeException("I18N: IO issues while parsing translation resource " + stream.toString());
        }
        return this.translations;
    }

    private void parseCatalog(Catalog catalog) {
        for (Message msg : catalog) {
            this.translations.put(msg.getMsgid(), msg.getMsgstr());
        }
    }
}

