/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.jsp;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class JSPUtils {
    private final HttpServletRequest request;
    private final HttpSession session;

    public JSPUtils(HttpServletRequest request, HttpSession session) {
        this.request = request;
        this.session = session;
    }

    public String getSessionOrCookie(String name, String defaultValue) {
        Cookie[] cookies;
        String result = (String)this.session.getAttribute(name);
        if (result == null && (cookies = this.request.getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(name)) continue;
                result = cookies[i].getValue();
                break;
            }
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public String getParameter(String name, String defaultValue) {
        String result = this.request.getParameter(name);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public String getParameter(String name) {
        return this.getParameter(name, null);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public boolean getParameter(String name, boolean defaultValue) {
        block4: {
            String result = this.request.getParameter(name);
            if (result != null) {
                try {
                    int intValue = Integer.parseInt(result);
                    return intValue > 0;
                }
                catch (NumberFormatException e) {
                    if ("false".equalsIgnoreCase(result) || "no".equals(result)) {
                        return false;
                    }
                    if (!"true".equalsIgnoreCase(result) && !"yes".equals(result)) break block4;
                    return false;
                }
            }
        }
        return defaultValue;
    }

    public int getParameter(String name, int defaultValue) {
        String result = this.request.getParameter(name);
        if (result != null) {
            try {
                return Integer.parseInt(result);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

