/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.page;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.bonitasoft.console.common.server.preferences.constants.WebBonitaConstantsUtils;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.api.TenantAdministrationAPI;
import org.bonitasoft.engine.business.data.BusinessDataRepositoryException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.io.IOUtil;
import org.bonitasoft.engine.session.APISession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDMClientDependenciesResolver {
    private final APISession session;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BDMClientDependenciesResolver.class.getName());
    private final Set<String> dependenciesNames = new HashSet<String>();

    public BDMClientDependenciesResolver(APISession session) {
        this.session = session;
    }

    public URL[] getBDMDependencies() throws IOException {
        if (!this.isBDMDeployed()) {
            return new URL[0];
        }
        File currentBDMFolder = this.getCurrentBDMFolder();
        if (this.shouldUpdateBDMDependencies(currentBDMFolder)) {
            this.cleanBDMFolder(currentBDMFolder);
            this.createBDMClientFolder(currentBDMFolder);
        }
        return this.getBDMLibrariesURLs(currentBDMFolder);
    }

    private boolean isBDMDeployed() {
        return this.getBusinessDataModelVersion() != null;
    }

    private boolean shouldUpdateBDMDependencies(File currentBDMFolder) {
        return !currentBDMFolder.exists() || currentBDMFolder.listFiles().length == 0;
    }

    private File getCurrentBDMFolder() {
        File bdmWorkDir = null;
        String businessDataModelVersion = this.getBusinessDataModelVersion();
        if (businessDataModelVersion != null) {
            bdmWorkDir = new File(WebBonitaConstantsUtils.getTenantInstance().geBDMWorkFolder(), businessDataModelVersion);
        }
        return bdmWorkDir;
    }

    private void cleanBDMFolder(File currentBDMFolder) {
        File parentFile = currentBDMFolder.getParentFile();
        if (parentFile != null && parentFile.exists()) {
            for (File previousDeployedBDM : parentFile.listFiles()) {
                if (!previousDeployedBDM.isDirectory()) continue;
                try {
                    FileUtils.deleteDirectory((File)previousDeployedBDM);
                }
                catch (IOException e) {
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn("Unable to delete obsolete BDM libraries", (Throwable)e);
                }
            }
        }
    }

    private void createBDMClientFolder(File bdmWorkDir) {
        block3: {
            if (!bdmWorkDir.exists()) {
                bdmWorkDir.mkdirs();
            }
            ByteArrayInputStream inpuStream = null;
            try {
                TenantAdministrationAPI tenantAdministrationAPI = this.getTenantAdminstrationAPI();
                inpuStream = new ByteArrayInputStream(tenantAdministrationAPI.getClientBDMZip());
                IOUtil.unzipToFolder((InputStream)inpuStream, (File)bdmWorkDir);
            }
            catch (IOException | BusinessDataRepositoryException | BonitaHomeNotSetException | ServerAPIException | UnknownAPITypeException e) {
                String message = "Unable to create the class loader for the BDM libraries";
                if (!LOGGER.isErrorEnabled()) break block3;
                LOGGER.error("Unable to create the class loader for the BDM libraries", e);
            }
        }
    }

    protected TenantAdministrationAPI getTenantAdminstrationAPI() throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getTenantAdministrationAPI((APISession)this.session);
    }

    public String getBusinessDataModelVersion() {
        try {
            TenantAdministrationAPI tenantAdministrationAPI = this.getTenantAdminstrationAPI();
            return tenantAdministrationAPI.getBusinessDataModelVersion();
        }
        catch (Exception e) {
            LOGGER.error("Unable to retrieve business data model version", (Throwable)e);
            return null;
        }
    }

    private URL[] getBDMLibrariesURLs(File bdmFolder) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : bdmFolder.listFiles()) {
            if (!file.getName().endsWith(".jar")) continue;
            this.dependenciesNames.add(file.getName());
            urls.add(file.toURI().toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public boolean isABDMDependency(String resourceName) {
        return this.dependenciesNames.contains(resourceName);
    }
}

