/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.page;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.FileUtils;
import org.bonitasoft.console.common.server.page.BDMClientDependenciesResolver;
import org.bonitasoft.console.common.server.page.CustomPageChildFirstClassLoader;
import org.bonitasoft.console.common.server.page.CustomPageDependenciesResolver;
import org.bonitasoft.console.common.server.page.VersionedClassloader;
import org.bonitasoft.console.common.server.page.extension.PageResourceProviderImpl;
import org.bonitasoft.console.common.server.preferences.constants.WebBonitaConstantsUtils;
import org.bonitasoft.console.common.server.preferences.properties.PropertiesFactory;
import org.bonitasoft.console.common.server.preferences.properties.PropertiesWithSet;
import org.bonitasoft.console.common.server.utils.UnzipUtil;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.api.PermissionAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.page.Page;
import org.bonitasoft.engine.page.PageNotFoundException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.extension.page.PageController;
import org.bonitasoft.web.extension.page.PageResourceProvider;
import org.bonitasoft.web.extension.rest.RestApiController;
import org.bonitasoft.web.rest.server.api.extension.ControllerClassName;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPageService {
    public static final String PAGE_CONTROLLER_FILENAME = "Index.groovy";
    public static final String PAGE_INDEX_NAME = "index";
    public static final String PAGE_INDEX_FILENAME = "index.html";
    private static final ConcurrentMap<String, GroovyClassLoader> PAGES_CLASSLOADERS = new ConcurrentHashMap<String, GroovyClassLoader>();
    private static final ConcurrentMap<String, Long> PAGES_UPDATE_TIMESTAMPS = new ConcurrentHashMap<String, Long>();
    private static final ConcurrentMap<String, Long> PAGES_LAST_UPDATE_DB_CHECK = new ConcurrentHashMap<String, Long>();
    private static final ConcurrentMap<String, Object> PAGES_LOCKS = new ConcurrentHashMap<String, Object>();
    public static final String RESOURCES_PROPERTY = "resources";
    public static final String PROPERTY_CONTENT_TYPE = "contentType";
    public static final String NAME_PROPERTY = "name";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CustomPageService.class.getName());

    public GroovyClassLoader getPageClassloader(APISession apiSession, PageResourceProvider pageResourceProvider) throws IOException, CompilationFailedException {
        return this.buildPageClassloader(apiSession, pageResourceProvider.getFullPageName(), pageResourceProvider.getPageDirectory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensurePageFolderIsPresent(APISession apiSession, PageResourceProvider pageResourceProvider) throws BonitaException, IOException {
        String fullPageName = pageResourceProvider.getFullPageName();
        Object object = this.getPageLock(fullPageName);
        synchronized (object) {
            File pageDirectory = pageResourceProvider.getPageDirectory();
            if (!pageDirectory.exists() || pageDirectory.list().length == 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("No page folder for page: " + fullPageName);
                }
                this.retrievePageZipContent(apiSession, pageResourceProvider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensurePageFolderIsUpToDate(APISession apiSession, PageResourceProvider pageResourceProvider) throws BonitaException, IOException {
        String fullPageName = pageResourceProvider.getFullPageName();
        Object object = this.getPageLock(fullPageName);
        synchronized (object) {
            Long pageTimestampFromCache = this.getPageTimestampFromMemoryCache(fullPageName);
            if (pageTimestampFromCache != null) {
                if (this.shouldVerifyLastUpdateDateInDatabaseAndFolderHealthy(fullPageName)) {
                    long databaseLastUpdateTimestamp = this.getPageLastUpdateDateFromEngine(apiSession, pageResourceProvider);
                    if (databaseLastUpdateTimestamp != pageTimestampFromCache) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Local update will be performed for page: " + fullPageName);
                        }
                        this.removePage(pageResourceProvider, true);
                        this.retrievePageZipContent(apiSession, pageResourceProvider);
                    } else {
                        this.ensurePageTempFolderIsHealthy(apiSession, pageResourceProvider);
                    }
                }
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Local retrieval of page: " + fullPageName);
                }
                this.retrievePageZipContent(apiSession, pageResourceProvider);
            }
        }
    }

    protected void ensurePageTempFolderIsHealthy(APISession apiSession, PageResourceProvider pageResourceProvider) throws IOException, BonitaException {
        File pageFolder = pageResourceProvider.getPageDirectory();
        if (!pageFolder.exists() || pageFolder.list().length == 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Page folder does not seem to be healthy for page: " + pageResourceProvider.getFullPageName());
            }
            this.removePage(pageResourceProvider, true);
            this.retrievePageZipContent(apiSession, pageResourceProvider);
        }
    }

    protected boolean shouldVerifyLastUpdateDateInDatabaseAndFolderHealthy(String fullPageName) {
        Long lastTimePageUpdateWasCheckedInDB = this.getLastTimePageUpdateWasCheckedInDB(fullPageName);
        if (lastTimePageUpdateWasCheckedInDB != null) {
            return System.currentTimeMillis() - lastTimePageUpdateWasCheckedInDB > this.getPageLastUpdateCheckInterval();
        }
        return true;
    }

    public Class<?> registerPage(GroovyClassLoader pageClassLoader, PageResourceProvider pageResourceProvider) throws CompilationFailedException, IOException {
        File pageControllerFile = this.getGroovyPageFile(pageResourceProvider.getPageDirectory());
        return pageClassLoader.parseClass(pageControllerFile);
    }

    public Class<?> registerRestApiPage(GroovyClassLoader pageClassLoader, PageResourceProviderImpl pageResourceProvider, ControllerClassName restApiControllerClassName, String mappingKey) throws BonitaException {
        try {
            if (restApiControllerClassName.isSource()) {
                File groovyFile = this.toFile(pageResourceProvider, restApiControllerClassName.getName());
                if (groovyFile.exists()) {
                    return pageClassLoader.parseClass(groovyFile);
                }
                LOGGER.error("resource does not exists:" + mappingKey);
                throw new BonitaException("unable to handle rest api call to " + mappingKey);
            }
            return pageClassLoader.loadClass(restApiControllerClassName.getName());
        }
        catch (IOException | ClassNotFoundException | CompilationFailedException e) {
            throw new BonitaException(e.getMessage(), e);
        }
    }

    protected File toFile(PageResourceProviderImpl pageResourceProvider, String classFileName) {
        String[] paths;
        if (classFileName.startsWith("/")) {
            classFileName = classFileName.substring(1);
        }
        Path restApiControllerPath = (paths = classFileName.split("/")).length == 1 ? Paths.get(paths[0], new String[0]) : Paths.get(paths[0], Arrays.copyOfRange(paths, 1, paths.length));
        return pageResourceProvider.getPageDirectory().toPath().resolve(restApiControllerPath).toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyPageClass(File tempPageDirectory, APISession session) throws IOException {
        File pageControllerFile = this.getPageFile(tempPageDirectory, PAGE_CONTROLLER_FILENAME);
        if (pageControllerFile.exists()) {
            String classloaderName = String.valueOf(System.currentTimeMillis());
            GroovyClassLoader pageClassLoader = this.buildPageClassloader(session, classloaderName, tempPageDirectory);
            try {
                pageClassLoader.parseClass(pageControllerFile);
            }
            catch (CompilationFailedException ex) {
                LOGGER.error("Failed to compile Index.groovy ", (Throwable)ex);
            }
            finally {
                GroovyClassLoader classLoader = (GroovyClassLoader)PAGES_CLASSLOADERS.remove(classloaderName);
                if (classLoader != null) {
                    classLoader.close();
                }
            }
        }
    }

    public PageController loadPage(Class<PageController> pageClass) throws InstantiationException, IllegalAccessException {
        return pageClass.newInstance();
    }

    public RestApiController loadRestApiPage(Class<RestApiController> restApiControllerClass) throws InstantiationException, IllegalAccessException {
        return restApiControllerClass.newInstance();
    }

    protected void removePage(PageResourceProvider pageResourceProvider, boolean ignoreErrorOnPageDirectoryDelete) throws IOException {
        String fullPageName = pageResourceProvider.getFullPageName();
        CustomPageService.closeClassloader(fullPageName);
        this.removePageZipContent(pageResourceProvider.getPageDirectory(), ignoreErrorOnPageDirectoryDelete);
        CustomPageDependenciesResolver.removePageLibTempFolder(fullPageName);
        this.removePageTimestampsFromMemoryCache(fullPageName);
    }

    public void removePageLocally(Page page) throws IOException {
        PageResourceProviderImpl pageResourceProvider = new PageResourceProviderImpl(page);
        this.removePageLocally(pageResourceProvider);
    }

    public void removePageLocally(PageResourceProvider pageResourceProvider) throws IOException {
        this.removePage(pageResourceProvider, false);
        this.removePageLock(pageResourceProvider.getFullPageName());
    }

    protected Object getPageLock(String fullPageName) {
        return PAGES_LOCKS.computeIfAbsent(fullPageName, k -> new Object());
    }

    protected void removePageLock(String fullPageName) {
        PAGES_LOCKS.remove(fullPageName);
    }

    protected void addPageTimestampToMemoryCache(String fullPageName, long timestamp) {
        PAGES_UPDATE_TIMESTAMPS.put(fullPageName, timestamp);
    }

    protected void setTimePageUpdateWasCheckedInDB(String fullPageName) {
        PAGES_LAST_UPDATE_DB_CHECK.put(fullPageName, System.currentTimeMillis());
    }

    protected Long getPageTimestampFromMemoryCache(String fullPageName) {
        return (Long)PAGES_UPDATE_TIMESTAMPS.get(fullPageName);
    }

    protected Long getLastTimePageUpdateWasCheckedInDB(String fullPageName) {
        return (Long)PAGES_LAST_UPDATE_DB_CHECK.get(fullPageName);
    }

    protected void removePageTimestampsFromMemoryCache(String fullPageName) {
        PAGES_LAST_UPDATE_DB_CHECK.remove(fullPageName);
        PAGES_UPDATE_TIMESTAMPS.remove(fullPageName);
    }

    protected void clearPageTimestampsMemoryCache() {
        PAGES_UPDATE_TIMESTAMPS.clear();
        PAGES_LAST_UPDATE_DB_CHECK.clear();
    }

    private static void closeClassloader(String pageName) throws IOException {
        GroovyClassLoader classloader = (GroovyClassLoader)PAGES_CLASSLOADERS.remove(pageName);
        if (classloader != null) {
            classloader.clearCache();
            classloader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected GroovyClassLoader buildPageClassloader(APISession apiSession, String pageName, File pageDirectory) throws CompilationFailedException, IOException {
        BDMClientDependenciesResolver bdmDependenciesResolver = new BDMClientDependenciesResolver(apiSession);
        if (this.isPageInDebugMode()) {
            Class<CustomPageService> clazz = CustomPageService.class;
            synchronized (CustomPageService.class) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return this.createPageClassloader(pageName, pageDirectory, bdmDependenciesResolver);
            }
        }
        GroovyClassLoader pageClassLoader = (GroovyClassLoader)PAGES_CLASSLOADERS.get(pageName);
        if (pageClassLoader != null && !this.isOutdated(pageClassLoader, bdmDependenciesResolver)) return pageClassLoader;
        Class<CustomPageService> clazz = CustomPageService.class;
        synchronized (CustomPageService.class) {
            if (pageClassLoader == null) {
                pageClassLoader = (GroovyClassLoader)PAGES_CLASSLOADERS.get(pageName);
                if (pageClassLoader != null && !this.isOutdated(pageClassLoader, bdmDependenciesResolver)) return pageClassLoader;
                pageClassLoader = this.createPageClassloader(pageName, pageDirectory, bdmDependenciesResolver);
                PAGES_CLASSLOADERS.put(pageName, pageClassLoader);
            } else {
                pageClassLoader.clearCache();
                pageClassLoader.close();
                pageClassLoader = this.createPageClassloader(pageName, pageDirectory, bdmDependenciesResolver);
                PAGES_CLASSLOADERS.put(pageName, pageClassLoader);
            }
            // ** MonitorExit[var6_8] (shouldn't be in output)
            return pageClassLoader;
        }
    }

    private GroovyClassLoader createPageClassloader(String pageName, File pageDirectory, BDMClientDependenciesResolver bdmDependenciesResolver) throws IOException {
        GroovyClassLoader pageClassLoader = new GroovyClassLoader(this.getParentClassloader(pageName, new CustomPageDependenciesResolver(pageName, pageDirectory, this.getWebBonitaConstantsUtils()), bdmDependenciesResolver));
        pageClassLoader.addClasspath(pageDirectory.getPath());
        return pageClassLoader;
    }

    private boolean isOutdated(GroovyClassLoader pageClassLoader, BDMClientDependenciesResolver bdmDependenciesResolver) {
        ClassLoader parent = pageClassLoader.getParent();
        if (!(parent instanceof VersionedClassloader)) {
            throw new IllegalStateException("Parent classloader should be versioned.");
        }
        VersionedClassloader cachedClassloader = (VersionedClassloader)((Object)parent);
        return !cachedClassloader.hasVersion(bdmDependenciesResolver.getBusinessDataModelVersion());
    }

    public boolean isPageInDebugMode() {
        return PropertiesFactory.getConsoleProperties().isPageInDebugMode();
    }

    public long getPageLastUpdateCheckInterval() {
        return PropertiesFactory.getConsoleProperties().getPageLastUpdateCheckInterval();
    }

    protected WebBonitaConstantsUtils getWebBonitaConstantsUtils() {
        return WebBonitaConstantsUtils.getTenantInstance();
    }

    protected ClassLoader getParentClassloader(String pageName, CustomPageDependenciesResolver customPageDependenciesResolver, BDMClientDependenciesResolver bdmDependenciesResolver) throws IOException {
        CustomPageChildFirstClassLoader classLoader = new CustomPageChildFirstClassLoader(pageName, customPageDependenciesResolver, bdmDependenciesResolver, Thread.currentThread().getContextClassLoader());
        classLoader.addCustomPageResources();
        return classLoader;
    }

    protected void retrievePageZipContent(APISession apiSession, PageResourceProvider pageResourceProvider) throws BonitaException, IOException {
        Page page;
        PageAPI pageAPI;
        byte[] pageContent;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Retrieving page content for page: " + pageResourceProvider.getFullPageName());
        }
        if ((pageContent = (pageAPI = this.getPageAPI(apiSession)).getPageContent((page = pageResourceProvider.getPage(pageAPI)).getId())).length == 0) {
            throw new BonitaException("No content available for page: " + page.getName());
        }
        File tempPageFile = ((PageResourceProviderImpl)pageResourceProvider).getTempPageFile();
        FileUtils.writeByteArrayToFile((File)tempPageFile, (byte[])pageContent);
        UnzipUtil.unzip(tempPageFile, pageResourceProvider.getPageDirectory().getPath(), true);
        long lastUpdateTimestamp = 0L;
        if (page.getLastModificationDate() != null) {
            lastUpdateTimestamp = page.getLastModificationDate().getTime();
        }
        String fullPageName = pageResourceProvider.getFullPageName();
        this.addPageTimestampToMemoryCache(fullPageName, lastUpdateTimestamp);
        this.setTimePageUpdateWasCheckedInDB(fullPageName);
    }

    protected PageAPI getPageAPI(APISession apiSession) throws BonitaException {
        return TenantAPIAccessor.getCustomPageAPI((APISession)apiSession);
    }

    protected PermissionAPI getPermissionAPI(APISession apiSession) throws BonitaException {
        return TenantAPIAccessor.getPermissionAPI((APISession)apiSession);
    }

    protected void removePageZipContent(File pageDirectory, boolean ignoreErrorOnPageDirectoryDelete) throws IOException {
        block4: {
            try {
                FileUtils.deleteDirectory((File)pageDirectory);
            }
            catch (IOException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Unable delete page folder. " + e.getMessage());
                }
                if (ignoreErrorOnPageDirectoryDelete) break block4;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Page folder will be removed when jvm shuts down.");
                }
                pageDirectory.deleteOnExit();
            }
        }
    }

    public File getGroovyPageFile(File pageDirectory) {
        return this.getPageFile(pageDirectory, PAGE_CONTROLLER_FILENAME);
    }

    public File getPageFile(File pageDirectory, String fileName) {
        return new File(pageDirectory, fileName);
    }

    protected long getPageLastUpdateDateFromEngine(APISession apiSession, PageResourceProvider pageResourceProvider) throws BonitaException {
        long lastUpdate;
        block3: {
            lastUpdate = 0L;
            try {
                PageAPI pageAPI = this.getPageAPI(apiSession);
                Date lastUpdateDate = pageResourceProvider.getPage(pageAPI).getLastModificationDate();
                if (lastUpdateDate != null) {
                    lastUpdate = lastUpdateDate.getTime();
                }
            }
            catch (PageNotFoundException e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug("Unable to find the page " + pageResourceProvider);
            }
        }
        this.setTimePageUpdateWasCheckedInDB(pageResourceProvider.getFullPageName());
        return lastUpdate;
    }

    public Properties getPageProperties(APISession apiSession, byte[] zipContent, boolean checkIfItAlreadyExists, Long processDefinitionId) throws BonitaException {
        Properties properties;
        PageAPI pageAPI = this.getPageAPI(apiSession);
        if (processDefinitionId == null) {
            properties = pageAPI.getPageProperties(zipContent, checkIfItAlreadyExists);
        } else {
            properties = pageAPI.getPageProperties(zipContent, false);
            if (checkIfItAlreadyExists) {
                String pageName = properties.getProperty(NAME_PROPERTY);
                try {
                    pageAPI.getPageByNameAndProcessDefinitionId(pageName, processDefinitionId.longValue());
                    throw new AlreadyExistsException("A page with name " + pageName + " already exists for the process " + processDefinitionId);
                }
                catch (PageNotFoundException e) {
                    try {
                        pageAPI.getPageByName(pageName);
                        throw new AlreadyExistsException("A page with name " + pageName + " already exists for the tenant");
                    }
                    catch (PageNotFoundException pageNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        return properties;
    }

    public Set<String> getCustomPagePermissions(Properties pageProperties, APISession apiSession) throws BonitaException {
        PropertiesWithSet pagePropertiesWithSet = new PropertiesWithSet(pageProperties);
        HashSet<String> pageRestResources = new HashSet<String>(pagePropertiesWithSet.getPropertyAsSet(RESOURCES_PROPERTY));
        HashSet<String> permissions = new HashSet<String>();
        for (String pageRestResource : pageRestResources) {
            Set resourcePermissions = this.getPermissionAPI(apiSession).getResourcePermissions(pageRestResource);
            if (Collections.emptySet().equals(resourcePermissions)) {
                permissions.add("<" + pageRestResource + ">");
            }
            permissions.addAll(resourcePermissions);
        }
        return permissions;
    }

    public Page getPage(APISession apiSession, String pageName, long processDefinitionId) throws BonitaException {
        return this.getPageAPI(apiSession).getPageByNameAndProcessDefinitionId(pageName, processDefinitionId);
    }

    public Page getPage(APISession apiSession, long pageId) throws BonitaException {
        return this.getPageAPI(apiSession).getPage(pageId);
    }

    public PageResourceProvider getPageResourceProvider(Page page) {
        return new PageResourceProviderImpl(page);
    }

    public static void clearCachedClassloaders() throws IOException {
        for (String page : PAGES_CLASSLOADERS.keySet()) {
            CustomPageService.closeClassloader(page);
        }
    }

    public void writePageToPageDirectory(Page page, PageResourceProvider pageResourceProvider, File unzipPageTempFolder, APISession session) throws IOException {
        this.verifyPageClass(unzipPageTempFolder, session);
        File pageDirectory = pageResourceProvider.getPageDirectory();
        FileUtils.copyDirectory((File)unzipPageTempFolder, (File)pageDirectory);
        long lastUpdateTimestamp = 0L;
        if (page.getLastModificationDate() != null) {
            lastUpdateTimestamp = page.getLastModificationDate().getTime();
        }
        String fullPageName = pageResourceProvider.getFullPageName();
        this.addPageTimestampToMemoryCache(fullPageName, lastUpdateTimestamp);
        this.setTimePageUpdateWasCheckedInDB(fullPageName);
    }
}

