/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.preferences.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.bonitasoft.console.common.server.preferences.constants.WebBonitaConstantsUtils;
import org.bonitasoft.console.common.server.utils.PlatformManagementUtils;
import org.bonitasoft.engine.exception.BonitaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationFilesManager {
    private static final ConfigurationFilesManager INSTANCE = new ConfigurationFilesManager();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConfigurationFilesManager.class.getName());
    private Map<String, File> tenantsConfigurationFiles = new HashMap<String, File>();
    private Map<String, Properties> platformConfigurations = new HashMap<String, Properties>();
    private final Map<String, File> platformConfigurationFiles = new HashMap<String, File>();

    public static ConfigurationFilesManager getInstance() {
        return INSTANCE;
    }

    public Properties getPlatformProperties(String propertiesFile) {
        Properties properties = this.platformConfigurations.get(propertiesFile);
        if (properties == null) {
            return new Properties();
        }
        return properties;
    }

    Properties getAlsoCustomAndInternalPropertiesFromFilename(String propertiesFileName) {
        Properties properties = new Properties();
        try {
            Map<String, Properties> propertiesByFilename = this.getResources();
            if (propertiesByFilename.containsKey(propertiesFileName)) {
                String customSuffixedVersion;
                properties.putAll((Map<?, ?>)propertiesByFilename.get(propertiesFileName));
                String internalSuffixedVersion = this.getSuffixedPropertyFilename(propertiesFileName, "-internal");
                if (propertiesByFilename.containsKey(internalSuffixedVersion)) {
                    properties.putAll((Map<?, ?>)propertiesByFilename.get(internalSuffixedVersion));
                }
                if (propertiesByFilename.containsKey(customSuffixedVersion = this.getSuffixedPropertyFilename(propertiesFileName, "-custom"))) {
                    properties.putAll((Map<?, ?>)propertiesByFilename.get(customSuffixedVersion));
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("File " + propertiesFileName + " not found. Returning empty properties object.");
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot retrieve tenant configurations", (Throwable)e);
        }
        return properties;
    }

    public Properties getTenantProperties(String propertiesFileName) {
        return this.getAlsoCustomAndInternalPropertiesFromFilename(propertiesFileName);
    }

    public static Properties getProperties(byte[] content) {
        Properties properties = new Properties();
        if (content != null) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(content);){
                properties.load(inputStream);
            }
            catch (IOException ioe) {
                LOGGER.error("Cannot parse properties file content", (Throwable)ioe);
            }
        }
        return properties;
    }

    public void setPlatformConfigurations(Map<String, byte[]> configurationFiles) throws IOException {
        this.platformConfigurations = new HashMap<String, Properties>(configurationFiles.size());
        for (Map.Entry<String, byte[]> entry : configurationFiles.entrySet()) {
            if (entry.getKey().endsWith(".properties")) {
                this.platformConfigurations.put(entry.getKey(), ConfigurationFilesManager.getProperties(entry.getValue()));
                continue;
            }
            File file = new File(WebBonitaConstantsUtils.getPlatformInstance().getTempFolder(), entry.getKey());
            FileUtils.writeByteArrayToFile((File)file, (byte[])entry.getValue());
            this.platformConfigurationFiles.put(entry.getKey(), file);
        }
    }

    public void setTenantConfigurationFiles(Map<String, byte[]> configurationFiles) throws IOException {
        HashMap<String, File> tenantFiles = new HashMap<String, File>();
        for (Map.Entry<String, byte[]> entry : configurationFiles.entrySet()) {
            if (entry.getKey().endsWith(".properties")) continue;
            File file = new File(WebBonitaConstantsUtils.getTenantInstance().getTempFolder(), entry.getKey());
            FileUtils.writeByteArrayToFile((File)file, (byte[])entry.getValue());
            tenantFiles.put(entry.getKey(), file);
        }
        this.tenantsConfigurationFiles = tenantFiles;
    }

    public void removeProperty(String propertiesFilename, String propertyName) throws IOException {
        String internalFilename = this.getSuffixedPropertyFilename(propertiesFilename, "-internal");
        Map<String, Properties> resources = this.getResources();
        Properties properties = resources.get(internalFilename);
        if (properties != null) {
            properties.remove(propertyName);
            this.update(internalFilename, properties);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("File " + internalFilename + " not found. Cannot remove property '" + propertyName + "'.");
        }
    }

    private String getSuffixedPropertyFilename(String propertiesFilename, String suffix) {
        return propertiesFilename.replaceAll("\\.properties$", suffix + ".properties");
    }

    private void update(String propertiesFilename, Properties properties) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            properties.store(byteArrayOutputStream, "");
            this.getPlatformManagementUtils().updateConfigurationFile(propertiesFilename, byteArrayOutputStream.toByteArray());
        }
        catch (BonitaException e) {
            throw new IOException(e);
        }
    }

    PlatformManagementUtils getPlatformManagementUtils() {
        return new PlatformManagementUtils();
    }

    Map<String, Properties> getResources() throws IOException {
        return this.getPlatformManagementUtils().getTenantConfigurations();
    }

    public void setProperty(String propertiesFilename, String propertyName, String propertyValue) throws IOException {
        String internalFilename;
        Map<String, Properties> resources = this.getResources();
        Properties properties = resources.get(internalFilename = this.getSuffixedPropertyFilename(propertiesFilename, "-internal"));
        if (properties != null) {
            properties.setProperty(propertyName, propertyValue);
            this.update(internalFilename, properties);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("File " + internalFilename + " not found. Cannot remove property '" + propertyName + "'.");
        }
    }

    public File getTenantConfigurationFile(String fileName) {
        if (this.tenantsConfigurationFiles != null) {
            return this.tenantsConfigurationFiles.get(fileName);
        }
        return null;
    }

    public File getPlatformConfigurationFile(String fileName) {
        return this.platformConfigurationFiles.get(fileName);
    }
}

