/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.preferences.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class PropertiesWithSet
extends Properties {
    public PropertiesWithSet(Properties properties) {
        super(properties);
    }

    public PropertiesWithSet(File file) {
        try (FileInputStream inStream = new FileInputStream(file);){
            this.load(inStream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Set<String> getPropertyAsSet(String propertyName) {
        return PropertiesWithSet.stringToSet(this.getProperty(propertyName));
    }

    public static Set<String> stringToSet(String propertyValueAsString) {
        if (propertyValueAsString != null) {
            HashSet<String> propertiesSet = new HashSet<String>();
            String propertyValueAsStringTrimmed = propertyValueAsString.trim();
            if (propertyValueAsStringTrimmed.startsWith("[") && propertyValueAsStringTrimmed.endsWith("]")) {
                String[] propertyArray;
                String propertyCSV = propertyValueAsStringTrimmed.substring(1, propertyValueAsStringTrimmed.length() - 1);
                if ((propertyCSV = propertyCSV.trim()).isEmpty()) {
                    return Collections.emptySet();
                }
                for (String propertyValue : propertyArray = propertyCSV.split(",")) {
                    propertiesSet.add(propertyValue.trim());
                }
            } else {
                propertiesSet.add(propertyValueAsString);
            }
            return propertiesSet;
        }
        return Collections.emptySet();
    }
}

