/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.utils;

import org.bonitasoft.console.common.server.utils.BPMEngineException;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPMEngineAPIUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BPMEngineAPIUtil.class.getName());

    public ProcessAPI getProcessAPI(APISession session) throws BPMEngineException, InvalidSessionException {
        try {
            return TenantAPIAccessor.getProcessAPI((APISession)session);
        }
        catch (BonitaHomeNotSetException e) {
            String message = "Bonita home system variable is not defined";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Bonita home system variable is not defined", (Throwable)e);
            }
            throw new BPMEngineException("Bonita home system variable is not defined");
        }
        catch (UnknownAPITypeException e) {
            String message = "The engine API Implementation is unknown.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("The engine API Implementation is unknown.", (Throwable)e);
            }
            throw new BPMEngineException("The engine API Implementation is unknown.");
        }
        catch (ServerAPIException e) {
            String message = "The engine client was not able to communicate with the engine server.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("The engine client was not able to communicate with the engine server.", (Throwable)e);
            }
            throw new BPMEngineException("The engine client was not able to communicate with the engine server.");
        }
    }
}

