/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.utils;

import org.bonitasoft.console.common.server.preferences.constants.WebBonitaConstantsUtils;
import org.bonitasoft.console.common.server.utils.CacheUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantCacheUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TenantCacheUtil.class.getName());
    protected static String CACHE_DISK_STORE_PATH = null;
    protected static final String PROCESS_ACTOR_INITIATOR_CACHE = "processActorInitiatorCache";

    protected TenantCacheUtil() {
        try {
            CACHE_DISK_STORE_PATH = WebBonitaConstantsUtils.getTenantInstance().getFormsWorkFolder().getAbsolutePath();
        }
        catch (Exception e) {
            LOGGER.warn("Unable to retrieve the path of the cache disk store directory path.", (Throwable)e);
        }
    }

    public Long getProcessActorInitiatorId(Long processId) {
        return (Long)CacheUtil.get(CACHE_DISK_STORE_PATH, PROCESS_ACTOR_INITIATOR_CACHE, processId);
    }

    public Long storeProcessActorInitiatorId(Long processId, Long actorInitiatorId) {
        CacheUtil.store(CACHE_DISK_STORE_PATH, PROCESS_ACTOR_INITIATOR_CACHE, processId, actorInitiatorId);
        return actorInitiatorId;
    }

    public void clearProcessActorInitiators() {
        CacheUtil.clear(CACHE_DISK_STORE_PATH, PROCESS_ACTOR_INITIATOR_CACHE);
    }
}

