/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.server.servlet;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.engine.api.IdentityAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationExportServlet
extends HttpServlet {
    private static final String EXPORT_FILE_NAME = "Organization_Data.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)OrganizationExportServlet.class.getName());
    private static final long serialVersionUID = 7203686892997001991L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        APISession apiSession = (APISession)request.getSession().getAttribute("apiSession");
        ServletOutputStream out = null;
        try {
            String organizationContent = this.getIdentityAPI(apiSession).exportOrganization();
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/octet-stream");
            String encodedfileName = URLEncoder.encode(EXPORT_FILE_NAME, StandardCharsets.UTF_8);
            String userAgent = request.getHeader("User-Agent");
            if (userAgent != null && userAgent.contains("Firefox")) {
                response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedfileName);
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedfileName.replaceAll("\\_", " ") + "\"; filename*=UTF-8''" + encodedfileName);
            }
            out = response.getOutputStream();
            if (organizationContent == null) {
                response.setContentLength(0);
            } else {
                response.setContentLength(organizationContent.getBytes().length);
            }
            out.write(organizationContent.getBytes());
        }
        catch (InvalidSessionException e) {
            String message = "Session expired. Please log in again.";
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Session expired. Please log in again.", (Throwable)e);
            }
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    private IdentityAPI getIdentityAPI(APISession apiSession) throws InvalidSessionException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getIdentityAPI((APISession)apiSession);
    }
}

