/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.server.servlet;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessActorsExportServlet
extends HttpServlet {
    private static final String EXPORT_FILE_SUFFIX = "_Process_Actors.xml";
    private static final String PROCESS_ID = "processId";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ProcessActorsExportServlet.class.getName());
    private static final long serialVersionUID = -1463938254928196006L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String processId = request.getParameter(PROCESS_ID);
        APISession apiSession = (APISession)request.getSession().getAttribute("apiSession");
        ServletOutputStream out = null;
        try {
            ProcessAPI processAPI = TenantAPIAccessor.getProcessAPI((APISession)apiSession);
            String actorContent = processAPI.exportActorMapping(Long.parseLong(processId));
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/octet-stream");
            String encodedfileName = URLEncoder.encode(processId + EXPORT_FILE_SUFFIX, StandardCharsets.UTF_8);
            String userAgent = request.getHeader("User-Agent");
            if (userAgent != null && userAgent.contains("Firefox")) {
                response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedfileName);
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedfileName.replaceAll("\\_", " ") + "\"; filename*=UTF-8''" + encodedfileName);
            }
            out = response.getOutputStream();
            if (actorContent == null) {
                response.setContentLength(0);
            } else {
                response.setContentLength(actorContent.length());
            }
            out.write(actorContent.getBytes());
        }
        catch (InvalidSessionException e) {
            String message = "Session expires. Please login again.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Session expires. Please login again.", (Throwable)e);
            }
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }
}

