/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.application;

import java.util.List;
import java.util.Map;
import org.bonitasoft.web.rest.model.application.ApplicationDefinition;
import org.bonitasoft.web.rest.model.application.ApplicationItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.api.applicationpage.APIApplicationDataStoreFactory;
import org.bonitasoft.web.rest.server.api.deployer.DeployerFactory;
import org.bonitasoft.web.rest.server.api.deployer.PageDeployer;
import org.bonitasoft.web.rest.server.api.deployer.UserDeployer;
import org.bonitasoft.web.rest.server.datastore.application.ApplicationDataStoreCreator;
import org.bonitasoft.web.rest.server.datastore.organization.UserDatastore;
import org.bonitasoft.web.rest.server.framework.api.APIHasAdd;
import org.bonitasoft.web.rest.server.framework.api.APIHasDelete;
import org.bonitasoft.web.rest.server.framework.api.APIHasGet;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.api.APIHasUpdate;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APIApplication
extends ConsoleAPI<ApplicationItem>
implements APIHasAdd<ApplicationItem>,
APIHasSearch<ApplicationItem>,
APIHasGet<ApplicationItem>,
APIHasUpdate<ApplicationItem>,
APIHasDelete {
    private final ApplicationDataStoreCreator creator;
    private final APIApplicationDataStoreFactory applicationDataStoreFactory;

    public APIApplication(ApplicationDataStoreCreator creator, APIApplicationDataStoreFactory applicationDataStoreFactory) {
        this.creator = creator;
        this.applicationDataStoreFactory = applicationDataStoreFactory;
    }

    @Override
    @Deprecated(since="9.0.0")
    public ApplicationItem add(ApplicationItem item) {
        return this.creator.create(this.getEngineSession()).add(item);
    }

    @Override
    @Deprecated(since="9.0.0")
    public ApplicationItem update(APIID id, Map<String, String> attributes) {
        return this.creator.create(this.getEngineSession()).update(id, (Map)attributes);
    }

    @Override
    public ApplicationItem get(APIID id) {
        return this.creator.create(this.getEngineSession()).get(id);
    }

    @Override
    public void delete(List<APIID> ids) {
        this.creator.create(this.getEngineSession()).delete(ids);
    }

    @Override
    public ItemSearchResult<ApplicationItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        return this.creator.create(this.getEngineSession()).search(page, resultsByPage, search, orders, filters);
    }

    @Override
    public String defineDefaultSearchOrder() {
        return "displayName";
    }

    @Override
    protected ItemDefinition<ApplicationItem> defineItemDefinition() {
        return ApplicationDefinition.get();
    }

    @Override
    protected void fillDeploys(ApplicationItem item, List<String> deploys) {
        this.addDeployer(new UserDeployer(new UserDatastore(this.getEngineSession()), "createdBy"));
        this.addDeployer(new UserDeployer(new UserDatastore(this.getEngineSession()), "updatedBy"));
        this.addDeployer(this.getDeployerFactory().createProfileDeployer("profileId"));
        this.addDeployer(new PageDeployer(this.applicationDataStoreFactory.createPageDataStore(this.getEngineSession()), "layoutId"));
        this.addDeployer(new PageDeployer(this.applicationDataStoreFactory.createPageDataStore(this.getEngineSession()), "themeId"));
        super.fillDeploys(item, deploys);
    }

    protected DeployerFactory getDeployerFactory() {
        return new DeployerFactory(this.getEngineSession());
    }
}

