/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.cases;

import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.data.ArchivedDataInstance;
import org.bonitasoft.engine.bpm.data.ArchivedDataNotFoundException;
import org.bonitasoft.web.rest.model.bpm.cases.ArchivedCaseVariable;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.bonitasoft.web.toolkit.client.common.exception.api.APINotFoundException;
import org.restlet.resource.Get;

public class ArchivedCaseVariableResource
extends CommonResource {
    static final String CASE_ID = "caseId";
    static final String VARIABLE_NAME = "variableName";
    private final ProcessAPI processAPI;

    public ArchivedCaseVariableResource(ProcessAPI processAPI) {
        this.processAPI = processAPI;
    }

    @Get(value="json")
    public ArchivedCaseVariable getArchivedCaseVariable() {
        String name = this.getAttribute(VARIABLE_NAME);
        if (name == null || name.isBlank()) {
            throw new IllegalArgumentException("Attribute 'variableName' is mandatory in order to get the archived case variable");
        }
        try {
            ArchivedDataInstance archivedProcessDataInstance = this.processAPI.getArchivedProcessDataInstance(name, this.getCaseIdParameter());
            return ArchivedCaseVariable.create(archivedProcessDataInstance);
        }
        catch (ArchivedDataNotFoundException e) {
            throw new APINotFoundException(e);
        }
    }

    private long getCaseIdParameter() {
        String caseId = this.getAttribute(CASE_ID);
        if (caseId == null) {
            throw new IllegalArgumentException("Attribute 'caseId' is mandatory in order to get the archived case variable");
        }
        return Long.parseLong(caseId);
    }
}

