/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.flownode;

import java.util.List;
import java.util.Map;
import org.bonitasoft.web.rest.model.bpm.flownode.HumanTaskDefinition;
import org.bonitasoft.web.rest.model.bpm.flownode.IHumanTaskItem;
import org.bonitasoft.web.rest.server.api.bpm.flownode.AbstractAPITask;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.HumanTaskDatastore;
import org.bonitasoft.web.rest.server.framework.api.Datastore;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIForbiddenException;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class AbstractAPIHumanTask<ITEM extends IHumanTaskItem>
extends AbstractAPITask<ITEM> {
    @Override
    protected HumanTaskDefinition defineItemDefinition() {
        return HumanTaskDefinition.get();
    }

    @Override
    protected Datastore defineDefaultDatastore() {
        return new HumanTaskDatastore(this.getEngineSession());
    }

    @Override
    public String defineDefaultSearchOrder() {
        return "priority DESC";
    }

    @Override
    public ITEM update(APIID id, Map<String, String> attributes) {
        String assignedUserId = attributes.get("assigned_id");
        if (assignedUserId != null && assignedUserId.length() > 0) {
            IHumanTaskItem humanTask = (IHumanTaskItem)this.get(id);
            if ("MANUAL_TASK".equals(humanTask.getType()) && StringUtil.isBlank(assignedUserId)) {
                throw new APIForbiddenException("Can't unassigned a manual task.");
            }
            if (humanTask.getAttributes().containsKey("assigned_id") && humanTask.getAttributeValue("assigned_id") != null && !humanTask.getAttributeValue("assigned_id").equals(assignedUserId)) {
                throw new APIForbiddenException("Can't assign this task because it has already been assigned.");
            }
        }
        return (ITEM)((IHumanTaskItem)super.update(id, (Map)attributes));
    }

    @Override
    protected List<String> defineReadOnlyAttributes() {
        List<String> attributes = super.defineReadOnlyAttributes();
        attributes.add("actorId");
        attributes.add("assigned_date");
        attributes.remove("executedBy");
        return attributes;
    }
}

