/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.flownode;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.flownode.UserTaskNotFoundException;
import org.bonitasoft.engine.expression.ExpressionEvaluationException;
import org.bonitasoft.web.rest.server.FinderFactory;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.restlet.resource.Get;

public class UserTaskContextResource
extends CommonResource {
    static final String TASK_ID = "taskId";
    private final ProcessAPI processAPI;
    private final FinderFactory resourceHandler;

    public UserTaskContextResource(ProcessAPI processAPI, FinderFactory resourceHandler) {
        this.processAPI = processAPI;
        this.resourceHandler = resourceHandler;
    }

    @Get(value="json")
    public Map<String, Serializable> getUserTaskContext() throws UserTaskNotFoundException, ExpressionEvaluationException {
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        Map userTaskExecutionContext = this.processAPI.getUserTaskExecutionContext(this.getTaskIdParameter());
        for (Map.Entry executionContextElement : userTaskExecutionContext.entrySet()) {
            resultMap.put((String)executionContextElement.getKey(), this.getContextResultElement((Serializable)executionContextElement.getValue()));
        }
        return resultMap;
    }

    private Serializable getContextResultElement(Serializable executionContextElementValue) {
        return this.resourceHandler.getContextResultElement(executionContextElementValue);
    }

    protected long getTaskIdParameter() {
        String taskId = this.getAttribute(TASK_ID);
        if (taskId == null) {
            throw new APIException("Attribute 'taskId' is mandatory in order to get the task context");
        }
        return Long.parseLong(taskId);
    }
}

