/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.flownode.archive;

import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.data.ArchivedDataNotFoundException;
import org.bonitasoft.web.rest.model.bpm.cases.ArchivedActivityVariable;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.bonitasoft.web.toolkit.client.common.exception.api.APINotFoundException;
import org.restlet.resource.Get;

public class ArchivedActivityVariableResource
extends CommonResource {
    public static final String ACTIVITYDATA_ACTIVITY_ID = "activityId";
    public static final String VARIABLE_NAME = "variableName";
    private final ProcessAPI processAPI;

    public ArchivedActivityVariableResource(ProcessAPI processAPI) {
        this.processAPI = processAPI;
    }

    @Get(value="json")
    public ArchivedActivityVariable getArchivedActivityVariable() {
        String name = this.getAttribute(VARIABLE_NAME);
        if (name == null || name.isBlank()) {
            throw new IllegalArgumentException("Attribute 'variableName' is mandatory in order to get the archived case variable");
        }
        try {
            return ArchivedActivityVariable.create(this.processAPI.getArchivedActivityDataInstance(name, this.getActivityIdParameter()));
        }
        catch (ArchivedDataNotFoundException e) {
            throw new APINotFoundException(e);
        }
    }

    private long getActivityIdParameter() {
        String activityId = this.getAttribute(ACTIVITYDATA_ACTIVITY_ID);
        if (activityId == null) {
            throw new IllegalArgumentException("Attribute 'activityId' is mandatory in order to get the archived activity variable");
        }
        return Long.parseLong(activityId);
    }
}

