/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.process;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.connector.ConnectorCriterion;
import org.bonitasoft.web.rest.model.bpm.process.ProcessConnectorDependencyDefinition;
import org.bonitasoft.web.rest.model.bpm.process.ProcessConnectorDependencyItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.datastore.bpm.process.ProcessConnectorDependencyDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.process.ProcessDatastore;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.exception.APIFilterMandatoryException;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;

public class APIProcessConnectorDependency
extends ConsoleAPI<ProcessConnectorDependencyItem>
implements APIHasSearch<ProcessConnectorDependencyItem> {
    protected ProcessConnectorDependencyDefinition defineItemDefinition() {
        return ProcessConnectorDependencyDefinition.get();
    }

    @Override
    public String defineDefaultSearchOrder() {
        return ConnectorCriterion.DEFINITION_ID_ASC.name();
    }

    @Override
    public ItemSearchResult<ProcessConnectorDependencyItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        this.checkMandatoryAttributes(filters);
        return super.search(page, resultsByPage, search, orders, filters);
    }

    protected void checkMandatoryAttributes(Map<String, String> filters) {
        if (MapUtil.isBlank(filters, "connector_process_id")) {
            throw new APIFilterMandatoryException("connector_process_id");
        }
        if (MapUtil.isBlank(filters, "connector_name")) {
            throw new APIFilterMandatoryException("connector_name");
        }
        if (MapUtil.isBlank(filters, "connector_version")) {
            throw new APIFilterMandatoryException("connector_version");
        }
    }

    @Override
    protected ProcessConnectorDependencyDatastore defineDefaultDatastore() {
        return new ProcessConnectorDependencyDatastore(this.getEngineSession());
    }

    @Override
    protected void fillDeploys(ProcessConnectorDependencyItem item, List<String> deploys) {
        if (this.isDeployable("connector_process_id", deploys, item)) {
            item.setDeploy("connector_process_id", new ProcessDatastore(this.getEngineSession()).get(item.getProcessId()));
        }
    }
}

