/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.parameter.ParameterCriterion;
import org.bonitasoft.engine.bpm.parameter.ParameterInstance;
import org.bonitasoft.engine.bpm.process.ProcessDefinition;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfo;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.web.rest.model.bpm.process.ProcessParameterItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.Definitions;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APIProcessParameter
extends ConsoleAPI<ProcessParameterItem> {
    @Override
    protected ItemDefinition defineItemDefinition() {
        return Definitions.get("processParameter");
    }

    protected ProcessAPI getProcessAPI() throws InvalidSessionException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
    }

    @Override
    public ProcessParameterItem get(APIID id) {
        List<String> ids = id.getIds();
        String processId = ids.get(0);
        String parameterName = ids.get(1);
        try {
            ProcessAPI processAPI = this.getProcessAPI();
            Long lProcessid = Long.valueOf(processId);
            ParameterInstance parameterInstance = processAPI.getParameterInstance(lProcessid.longValue(), parameterName);
            ProcessDefinition processDef = processAPI.getProcessDefinition(lProcessid.longValue());
            ProcessDeploymentInfo processDeploy = processAPI.getProcessDeploymentInfo(lProcessid.longValue());
            if (parameterInstance == null) {
                throw new APIItemNotFoundException("parameter", APIID.makeAPIID(String.valueOf(lProcessid), parameterName));
            }
            if (processDef == null) {
                throw new APIItemNotFoundException("process", APIID.makeAPIID(String.valueOf(lProcessid)));
            }
            String paramValue = parameterInstance.getValue() == null ? "" : parameterInstance.getValue().toString();
            return new ProcessParameterItem(processId, parameterInstance.getName(), parameterInstance.getType(), paramValue, parameterInstance.getDescription(), processDeploy.getDisplayName(), processDef.getVersion());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public String defineDefaultSearchOrder() {
        return ParameterCriterion.NAME_ASC.toString();
    }

    @Override
    public ItemSearchResult<ProcessParameterItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        ArrayList<ProcessParameterItem> items = new ArrayList<ProcessParameterItem>();
        List parameters = new ArrayList();
        int parametersCount = 0;
        long processId = -1L;
        try {
            ProcessAPI processAPI = this.getProcessAPI();
            if (filters != null && filters.containsKey("process_id")) {
                String value = filters.get("process_id");
                processId = Long.parseLong(value);
            }
            if (processId != -1L) {
                parameters = processAPI.getParameterInstances(processId, SearchOptionsBuilderUtil.computeIndex(page, resultsByPage), resultsByPage, ParameterCriterion.valueOf((String)orders.toUpperCase().replace(" ", "_")));
                parametersCount = processAPI.getNumberOfParameterInstances(processId);
            }
            for (ParameterInstance p : parameters) {
                String paramValue = p.getValue() == null ? "" : p.getValue().toString();
                items.add(new ProcessParameterItem(String.valueOf(processId), p.getName(), p.getType(), paramValue, p.getDescription(), "", ""));
            }
            return new ItemSearchResult<ProcessParameterItem>(page, resultsByPage, parametersCount, items);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    protected void fillDeploys(ProcessParameterItem item, List<String> deploys) {
    }

    @Override
    protected void fillCounters(ProcessParameterItem item, List<String> counters) {
    }
}

