/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.deployer;

import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.portal.profile.ProfileItem;
import org.bonitasoft.web.rest.server.api.deployer.GenericDeployer;
import org.bonitasoft.web.rest.server.api.deployer.UserDeployer;
import org.bonitasoft.web.rest.server.datastore.organization.UserDatastore;
import org.bonitasoft.web.rest.server.datastore.profile.GetProfileHelper;
import org.bonitasoft.web.rest.server.engineclient.EngineAPIAccessor;
import org.bonitasoft.web.rest.server.engineclient.EngineClientFactory;
import org.bonitasoft.web.rest.server.framework.Deployer;

public class DeployerFactory {
    private final APISession apiSession;
    private final EngineClientFactory factory;

    public DeployerFactory(APISession apiSession) {
        this.apiSession = apiSession;
        this.factory = new EngineClientFactory(new EngineAPIAccessor(apiSession));
    }

    public UserDeployer createUserDeployer(String attribute) {
        return new UserDeployer(new UserDatastore(this.apiSession), attribute);
    }

    public Deployer createProfileDeployer(String attribute) {
        return new GenericDeployer<ProfileItem>(this.createProfileGetter(), attribute);
    }

    private GetProfileHelper createProfileGetter() {
        return new GetProfileHelper(this.factory.createProfileEngineClient());
    }
}

