/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.deployer;

import org.bonitasoft.web.rest.model.portal.page.PageItem;
import org.bonitasoft.web.rest.server.framework.Deployer;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.IItem;

public class PageDeployer
implements Deployer {
    private final DatastoreHasGet<PageItem> getter;
    private final String attribute;

    public PageDeployer(DatastoreHasGet<PageItem> getter, String attribute) {
        this.getter = getter;
        this.attribute = attribute;
    }

    @Override
    public String getDeployedAttribute() {
        return this.attribute;
    }

    @Override
    public void deployIn(IItem item) {
        if (this.isDeployable(this.attribute, item)) {
            item.setDeploy(this.attribute, this.getPage(this.getPageId(item)));
        }
    }

    private APIID getPageId(IItem item) {
        return item.getAttributeValueAsAPIID(this.attribute);
    }

    private PageItem getPage(APIID pageId) {
        return this.getter.get(pageId);
    }
}

