/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.document;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.document.DocumentItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.api.document.api.impl.DocumentDatastore;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.Definitions;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APIDocument
extends ConsoleAPI<DocumentItem> {
    @Override
    protected ItemDefinition defineItemDefinition() {
        return Definitions.get("document");
    }

    protected DocumentDatastore getDataStore() {
        return new DocumentDatastore(this.getEngineSession());
    }

    @Override
    public DocumentItem get(APIID id) {
        APISession apiSession = this.getEngineSession();
        DocumentItem item = new DocumentItem();
        try {
            ProcessAPI processAPI = TenantAPIAccessor.getProcessAPI((APISession)apiSession);
            Document document = processAPI.getDocument(id.toLong().longValue());
            item = this.getDataStore().mapToDocumentItem(document);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
        return item;
    }

    @Override
    public String defineDefaultSearchOrder() {
        return "";
    }

    @Override
    public ItemSearchResult<DocumentItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        APISession apiSession = this.getEngineSession();
        ArrayList<DocumentItem> items = new ArrayList<DocumentItem>();
        long nbOfDocument = 0L;
        String caseId = null;
        String viewType = null;
        String documentName = null;
        long userId = -1L;
        try {
            if (filters != null) {
                if (filters.containsKey("CASE_ID")) {
                    caseId = filters.get("CASE_ID");
                }
                if (filters.containsKey("VIEW")) {
                    viewType = filters.get("VIEW");
                }
                if (filters.containsKey("USER_ID")) {
                    String user = filters.get("USER_ID");
                    userId = user != null ? Long.valueOf(user).longValue() : apiSession.getUserId();
                }
                if (filters.containsKey("documentName")) {
                    documentName = filters.get("documentName");
                }
            }
            SearchOptionsBuilder builder = SearchOptionsBuilderUtil.buildSearchOptions(page, resultsByPage, orders, search);
            if (caseId != null) {
                builder.filter("processinstanceid", (Serializable)((Object)caseId));
            }
            if (documentName != null) {
                builder.filter("documentName", documentName);
            }
            SearchResult<Document> result = null;
            if (viewType != null) {
                result = this.getDataStore().searchDocuments(userId, viewType, builder);
            }
            if (result != null) {
                nbOfDocument = result.getCount();
                for (Document document : result.getResult()) {
                    items.add(this.getDataStore().mapToDocumentItem(document));
                }
            }
        }
        catch (IllegalArgumentException | BonitaException e) {
            throw new APIException(e);
        }
        return new ItemSearchResult<DocumentItem>(page, resultsByPage, nbOfDocument, items);
    }

    @Override
    public DocumentItem add(DocumentItem item) {
        long processInstanceId = Long.valueOf(item.getAttributeValue("processinstanceId"));
        String documentName = item.getAttributeValue("documentName");
        String path = item.getAttributeValue("documentUpload");
        String documentCreationType = item.getAttributeValue("DOCUMENT_CREATION_TYPE");
        String urlPath = item.getAttributeValue("documentURL");
        try {
            DocumentItem returnedItem = new DocumentItem();
            if (processInstanceId != -1L && documentName != null && documentCreationType != null) {
                if (path != null && !path.isEmpty()) {
                    returnedItem = this.getDataStore().createDocument(processInstanceId, documentName, documentCreationType, path, new BonitaHomeFolderAccessor());
                } else if (urlPath != null && !urlPath.isEmpty()) {
                    returnedItem = this.getDataStore().createDocumentFromUrl(processInstanceId, documentName, documentCreationType, urlPath);
                }
                return returnedItem;
            }
            throw new APIException("Error while attaching a new document. Request with bad param value.");
        }
        catch (IOException | BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    protected void fillDeploys(DocumentItem item, List<String> deploys) {
    }

    @Override
    protected void fillCounters(DocumentItem item, List<String> counters) {
    }
}

