/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.form.FormMapping;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.web.rest.server.api.form.FormMappingItem;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.filter.FormMappingTypeCreator;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;

public class FormMappingResource
extends CommonResource {
    protected final ProcessAPI processAPI;

    public FormMappingResource(ProcessAPI processAPI) {
        this.processAPI = processAPI;
        this.setConditional(false);
    }

    @Get(value="json")
    public void searchFormMapping() throws ResourceException {
        try {
            SearchResult searchResult = this.processAPI.searchFormMappings(this.buildSearchOptions());
            List result = searchResult.getResult();
            List<FormMappingItem> resultConverted = this.convertMapping(result);
            Representation representation = this.getConverterService().toRepresentation(resultConverted, MediaType.APPLICATION_JSON);
            representation.setCharacterSet(CharacterSet.UTF_8);
            this.getResponse().setEntity(representation);
            this.setContentRange(searchResult);
        }
        catch (IOException | BonitaException e) {
            throw new APIException(e);
        }
    }

    private List<FormMappingItem> convertMapping(List<FormMapping> result) {
        ArrayList<FormMappingItem> convertedResult = new ArrayList<FormMappingItem>();
        for (FormMapping item : result) {
            convertedResult.add(new FormMappingItem(item));
        }
        return convertedResult;
    }

    @Override
    protected Filters buildFilters() {
        return new Filters(this.getSearchFilters(), new FormMappingTypeCreator());
    }
}

