/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.organization;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.identity.CustomUserInfo;
import org.bonitasoft.web.rest.model.identity.CustomUserInfoDefinition;
import org.bonitasoft.web.rest.model.identity.CustomUserInfoItem;
import org.bonitasoft.web.rest.server.api.APIPreconditions;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.api.organization.CustomUserInfoConverter;
import org.bonitasoft.web.rest.server.engineclient.CustomUserInfoEngineClient;
import org.bonitasoft.web.rest.server.engineclient.CustomUserInfoEngineClientCreator;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APICustomUserInfoUser
extends ConsoleAPI<CustomUserInfoItem>
implements APIHasSearch<CustomUserInfoItem> {
    public static final String FIX_ORDER = "Fix order";
    private final CustomUserInfoEngineClientCreator engineClientCreator;
    private final CustomUserInfoConverter converter = new CustomUserInfoConverter();

    public APICustomUserInfoUser(CustomUserInfoEngineClientCreator engineClientCreator) {
        this.engineClientCreator = engineClientCreator;
    }

    @Override
    public ItemSearchResult<CustomUserInfoItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        APIPreconditions.check(APIPreconditions.containsOnly("userId", filters), new T_("The only mandatory filter is %name%", new Arg("name", "userId")));
        APIPreconditions.check(orders.equals(FIX_ORDER), new T_("Sorting is not supported by this API"));
        APIPreconditions.check(search == null, new T_("Search terms are not supported by this API"));
        CustomUserInfoEngineClient client = this.engineClientCreator.create(this.getEngineSession());
        List<CustomUserInfo> items = client.listCustomInformation(Long.parseLong(filters.get("userId")), page * resultsByPage, resultsByPage);
        ArrayList<CustomUserInfoItem> information = new ArrayList<CustomUserInfoItem>();
        for (CustomUserInfo item : items) {
            information.add(this.converter.convert(item));
        }
        return new ItemSearchResult<CustomUserInfoItem>(page, information.size(), client.countDefinitions(), information);
    }

    @Override
    protected ItemDefinition<CustomUserInfoItem> defineItemDefinition() {
        return CustomUserInfoDefinition.get();
    }

    @Override
    public String defineDefaultSearchOrder() {
        return FIX_ORDER;
    }
}

