/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.profile;

import java.util.List;
import org.bonitasoft.web.rest.model.portal.profile.ProfileDefinition;
import org.bonitasoft.web.rest.model.portal.profile.ProfileItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.api.deployer.DeployerFactory;
import org.bonitasoft.web.rest.server.datastore.ComposedDatastore;
import org.bonitasoft.web.rest.server.datastore.profile.GetProfileHelper;
import org.bonitasoft.web.rest.server.datastore.profile.SearchProfilesHelper;
import org.bonitasoft.web.rest.server.engineclient.EngineAPIAccessor;
import org.bonitasoft.web.rest.server.engineclient.EngineClientFactory;
import org.bonitasoft.web.rest.server.engineclient.ProfileEngineClient;
import org.bonitasoft.web.rest.server.framework.api.APIHasGet;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APIProfile
extends ConsoleAPI<ProfileItem>
implements APIHasGet<ProfileItem>,
APIHasSearch<ProfileItem> {
    @Override
    protected void fillDeploys(ProfileItem item, List<String> deploys) {
        this.addDeployer(this.getDeployerFactory().createUserDeployer("createdBy"));
        this.addDeployer(this.getDeployerFactory().createUserDeployer("updatedBy"));
        super.fillDeploys(item, deploys);
    }

    protected DeployerFactory getDeployerFactory() {
        return new DeployerFactory(this.getEngineSession());
    }

    @Override
    protected ComposedDatastore<ProfileItem> defineDefaultDatastore() {
        ProfileEngineClient profileClient = this.createProfileEngineClient();
        ComposedDatastore<ProfileItem> datastore = new ComposedDatastore<ProfileItem>();
        datastore.setGetHelper(new GetProfileHelper(profileClient));
        datastore.setSearchHelper(new SearchProfilesHelper(profileClient));
        return datastore;
    }

    private ProfileEngineClient createProfileEngineClient() {
        return new EngineClientFactory(new EngineAPIAccessor(this.getEngineSession())).createProfileEngineClient();
    }

    @Override
    protected ItemDefinition<ProfileItem> defineItemDefinition() {
        return ProfileDefinition.get();
    }

    @Override
    public String defineDefaultSearchOrder() {
        return "name ASC";
    }
}

