/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.profile;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bonitasoft.web.rest.model.portal.profile.AbstractMemberItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.datastore.organization.GroupDatastore;
import org.bonitasoft.web.rest.server.datastore.organization.RoleDatastore;
import org.bonitasoft.web.rest.server.datastore.organization.UserDatastore;
import org.bonitasoft.web.rest.server.framework.api.APIHasAdd;
import org.bonitasoft.web.rest.server.framework.api.APIHasDelete;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.exception.APIAttributesException;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.IItem;
import org.bonitasoft.web.toolkit.client.data.item.Item;

public abstract class AbstractAPIMember<T extends AbstractMemberItem>
extends ConsoleAPI<T>
implements APIHasAdd<T>,
APIHasSearch<T>,
APIHasDelete {
    protected void checkAttributes(APIID userId, APIID roleId, APIID groupId) {
        this.checkUserAttributeIsAloneOrNull(userId, roleId, groupId);
        this.checkAnAttributeIsSet(userId, roleId, groupId);
    }

    private void checkUserAttributeIsAloneOrNull(APIID userId, APIID roleId, APIID groupId) {
        if (userId != null && (roleId != null || groupId != null)) {
            throw new APIAttributesException(Arrays.asList("user_id", "role_id", "group_id"), "User attribute must be alone or null");
        }
    }

    private void checkAnAttributeIsSet(APIID userId, APIID roleId, APIID groupId) {
        if (userId == null && roleId == null && groupId == null) {
            throw new APIAttributesException(Arrays.asList("user_id", "role_id", "group_id"), "At least one attribute must be set");
        }
    }

    @Override
    public T add(T item) {
        this.checkAttributes(((AbstractMemberItem)item).getUserId(), ((AbstractMemberItem)item).getRoleId(), ((AbstractMemberItem)item).getGroupId());
        return (T)((AbstractMemberItem)super.add(item));
    }

    @Override
    public void delete(List<APIID> ids) {
        super.delete(ids);
    }

    @Override
    public ItemSearchResult<T> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        this.checkUserAttributeIsAloneOrNull(APIID.makeAPIID(filters.get("user_id")), APIID.makeAPIID(filters.get("role_id")), APIID.makeAPIID(filters.get("group_id")));
        return super.search(page, resultsByPage, search, orders, filters);
    }

    @Override
    protected void fillDeploys(T item, List<String> deploys) {
        if (this.isDeployable("user_id", deploys, (IItem)item)) {
            ((Item)item).setDeploy("user_id", new UserDatastore(this.getEngineSession()).get(((AbstractMemberItem)item).getUserId()));
        }
        if (this.isDeployable("role_id", deploys, (IItem)item)) {
            ((Item)item).setDeploy("role_id", new RoleDatastore(this.getEngineSession()).get(((AbstractMemberItem)item).getRoleId()));
        }
        if (this.isDeployable("group_id", deploys, (IItem)item)) {
            ((Item)item).setDeploy("group_id", new GroupDatastore(this.getEngineSession()).get(((AbstractMemberItem)item).getGroupId()));
        }
    }
}

