/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.system;

import javax.servlet.http.HttpSession;
import org.bonitasoft.engine.api.MaintenanceAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.maintenance.MaintenanceDetails;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.system.MaintenanceDetailsClient;
import org.bonitasoft.web.rest.server.api.AbstractRESTController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/API/system/maintenance"})
public class MaintenanceController
extends AbstractRESTController {
    private static final Logger log = LoggerFactory.getLogger(MaintenanceController.class);

    @GetMapping(produces={"application/json"})
    public MaintenanceDetails getMaintenanceDetails(HttpSession session) {
        APISession apiSession = this.getApiSession(session);
        try {
            return this.getMaintenanceAPI(apiSession).getMaintenanceDetails();
        }
        catch (BonitaException e) {
            String errorMessage = "Error while getting the maintenance info";
            log.error(errorMessage, (Throwable)e);
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, errorMessage);
        }
    }

    @PutMapping(produces={"application/json"}, consumes={"application/json"})
    public MaintenanceDetails changeMaintenanceState(@RequestBody MaintenanceDetailsClient maintenanceInfo, HttpSession session) {
        APISession apiSession = this.getApiSession(session);
        try {
            MaintenanceAPI maintenanceAPI = this.getMaintenanceAPI(apiSession);
            MaintenanceDetails currentMaintenanceDetails = maintenanceAPI.getMaintenanceDetails();
            if (maintenanceInfo.getMaintenanceState() != null && currentMaintenanceDetails.getMaintenanceState() != maintenanceInfo.getMaintenanceState()) {
                if (MaintenanceDetails.State.ENABLED == maintenanceInfo.getMaintenanceState()) {
                    maintenanceAPI.enableMaintenanceMode();
                } else {
                    maintenanceAPI.disableMaintenanceMode();
                }
            }
            if (maintenanceInfo.isMaintenanceMessageActive() != null && currentMaintenanceDetails.isMaintenanceMessageActive() != maintenanceInfo.isMaintenanceMessageActive()) {
                if (maintenanceInfo.isMaintenanceMessageActive().booleanValue()) {
                    maintenanceAPI.enableMaintenanceMessage();
                } else {
                    maintenanceAPI.disableMaintenanceMessage();
                }
            }
            if (maintenanceInfo.getMaintenanceMessage() != null && currentMaintenanceDetails.getMaintenanceMessage() != maintenanceInfo.getMaintenanceMessage()) {
                maintenanceAPI.updateMaintenanceMessage(maintenanceInfo.getMaintenanceMessage());
            }
            return maintenanceAPI.getMaintenanceDetails();
        }
        catch (BonitaException e) {
            String errorMessage = "Error while setting the maintenance state";
            log.error(errorMessage, (Throwable)e);
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, errorMessage);
        }
    }

    protected MaintenanceAPI getMaintenanceAPI(APISession apiSession) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getMaintenanceAPI((APISession)apiSession);
    }
}

