/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.applicationpage;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.ApplicationAPI;
import org.bonitasoft.engine.business.application.ApplicationPage;
import org.bonitasoft.engine.business.application.ApplicationPageNotFoundException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.applicationpage.ApplicationPageItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.applicationpage.ApplicationPageFilterCreator;
import org.bonitasoft.web.rest.server.datastore.applicationpage.ApplicationPageItemConverter;
import org.bonitasoft.web.rest.server.datastore.applicationpage.ApplicationPageSearchDescriptorConverter;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.utils.SearchOptionsCreator;
import org.bonitasoft.web.rest.server.datastore.utils.Sorts;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class ApplicationPageDataStore
extends CommonDatastore<ApplicationPageItem, ApplicationPage>
implements DatastoreHasAdd<ApplicationPageItem>,
DatastoreHasGet<ApplicationPageItem>,
DatastoreHasSearch<ApplicationPageItem>,
DatastoreHasDelete {
    private final ApplicationAPI applicationAPI;
    private final ApplicationPageItemConverter converter;

    public ApplicationPageDataStore(APISession engineSession, ApplicationAPI applicationAPI, ApplicationPageItemConverter converter) {
        super(engineSession);
        this.applicationAPI = applicationAPI;
        this.converter = converter;
    }

    @Override
    @Deprecated(since="9.0.0")
    public ApplicationPageItem add(ApplicationPageItem item) {
        try {
            ApplicationPage applicationPage = this.applicationAPI.createApplicationPage(item.getApplicationId().toLong().longValue(), item.getPageId().toLong().longValue(), item.getToken());
            return this.converter.toApplicationPageItem(applicationPage);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ApplicationPageItem get(APIID id) {
        try {
            ApplicationPage applicationPage = this.applicationAPI.getApplicationPage(id.toLong().longValue());
            return this.converter.toApplicationPageItem(applicationPage);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public void delete(List<APIID> ids) {
        try {
            for (APIID id : ids) {
                this.applicationAPI.deleteApplicationPage(id.toLong().longValue());
            }
        }
        catch (BonitaException e) {
            if (e.getCause() instanceof ApplicationPageNotFoundException) {
                throw new APIItemNotFoundException("applicationpage");
            }
            throw new APIException(e);
        }
    }

    protected ApplicationPageSearchDescriptorConverter getSearchDescriptorConverter() {
        return new ApplicationPageSearchDescriptorConverter();
    }

    @Override
    protected ApplicationPageItem convertEngineToConsoleItem(ApplicationPage item) {
        return this.converter.toApplicationPageItem(item);
    }

    @Override
    public ItemSearchResult<ApplicationPageItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsCreator creator = this.makeSearchOptionCreator(page, resultsByPage, search, orders, filters);
        try {
            SearchResult<ApplicationPage> searchResult = this.runSearch(creator);
            List appPageItems = this.convertEngineToConsoleItemsList(searchResult.getResult());
            return new ItemSearchResult<ApplicationPageItem>(page, resultsByPage, searchResult.getCount(), appPageItems);
        }
        catch (SearchException e) {
            throw new APIException(e);
        }
    }

    protected SearchOptionsCreator makeSearchOptionCreator(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        return new SearchOptionsCreator(page, resultsByPage, search, new Sorts(orders, this.getSearchDescriptorConverter()), new Filters(filters, new ApplicationPageFilterCreator(this.getSearchDescriptorConverter())));
    }

    protected SearchResult<ApplicationPage> runSearch(SearchOptionsCreator creator) throws SearchException {
        return this.applicationAPI.searchApplicationPages(creator.create());
    }
}

