/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.cases;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.data.DataInstance;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.cases.CaseVariableItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.rest.server.framework.utils.converter.ConversionException;
import org.bonitasoft.web.rest.server.framework.utils.converter.TypeConverter;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIMethodNotAllowedException;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class CaseVariableDatastore
extends CommonDatastore<CaseVariableItem, DataInstance>
implements DatastoreHasSearch<CaseVariableItem>,
DatastoreHasUpdate<CaseVariableItem> {
    private final TypeConverter converter = new TypeConverter();

    public CaseVariableDatastore(APISession engineSession) {
        super(engineSession);
    }

    @Override
    protected CaseVariableItem convertEngineToConsoleItem(DataInstance item) {
        return new CaseVariableItem(item.getContainerId(), item.getName(), item.getValue(), item.getClassName(), item.getDescription());
    }

    private List<CaseVariableItem> convert(List<DataInstance> dataInstances) {
        ArrayList<CaseVariableItem> caseVariables = new ArrayList<CaseVariableItem>();
        for (DataInstance dataInstance : dataInstances) {
            caseVariables.add(this.convertEngineToConsoleItem(dataInstance));
        }
        return caseVariables;
    }

    protected ProcessAPI getEngineProcessAPI() {
        try {
            return TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public CaseVariableItem update(APIID id, Map<String, String> attributes) {
        throw new APIMethodNotAllowedException("Not implemented / No need to / Not used");
    }

    @Override
    public ItemSearchResult<CaseVariableItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        throw new APIMethodNotAllowedException("Not implemented / No need to / Not used");
    }

    public void updateVariableValue(long caseId, String variableName, String className, String newValue) {
        try {
            Serializable converteValue = this.converter.convert(className, newValue);
            this.getEngineProcessAPI().updateProcessDataInstance(variableName, caseId, converteValue);
        }
        catch (BonitaException | ConversionException e) {
            throw new APIException("Error when updating case variable", e);
        }
    }

    public ItemSearchResult<CaseVariableItem> findByCaseId(long caseId, int page, int resultsByPage) {
        try {
            List processDataInstances = this.getEngineProcessAPI().getProcessDataInstances(caseId, SearchOptionsBuilderUtil.computeIndex(page, resultsByPage), resultsByPage);
            return new ItemSearchResult<CaseVariableItem>(page, resultsByPage, this.countByCaseId(caseId), this.convert(processDataInstances));
        }
        catch (BonitaException e) {
            throw new APIException("Error when getting case variables", (Throwable)e);
        }
    }

    private long countByCaseId(long caseId) throws BonitaException {
        return this.getEngineProcessAPI().getNumberOfProcessDataInstances(caseId);
    }

    public CaseVariableItem findById(long caseId, String variableName) {
        try {
            return this.convertEngineToConsoleItem(this.getEngineProcessAPI().getProcessDataInstance(variableName, caseId));
        }
        catch (BonitaException e) {
            throw new APIException("Error while getting case variable", (Throwable)e);
        }
    }
}

