/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.flownode;

import java.io.Serializable;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.flownode.FlowNodeInstance;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.flownode.FlowNodeItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.FlowNodeConverter;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIMethodNotAllowedException;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class AbstractFlowNodeDatastore<CONSOLE_ITEM extends FlowNodeItem, ENGINE_ITEM extends FlowNodeInstance>
extends CommonDatastore<CONSOLE_ITEM, ENGINE_ITEM>
implements DatastoreHasSearch<CONSOLE_ITEM>,
DatastoreHasGet<CONSOLE_ITEM>,
DatastoreHasUpdate<CONSOLE_ITEM> {
    private DatastoreHasUpdate<FlowNodeItem> updateHelper;

    public AbstractFlowNodeDatastore(APISession engineSession) {
        super(engineSession);
    }

    protected static FlowNodeItem fillConsoleItem(FlowNodeItem result, FlowNodeInstance item) {
        result.setId(item.getId());
        result.setName(item.getName());
        result.setDisplayName(item.getDisplayName());
        result.setDescription(item.getDescription());
        result.setDisplayDescription(item.getDisplayDescription());
        result.setExecutedByUserId(item.getExecutedBy());
        result.setRootCaseId(item.getRootContainerId());
        result.setParentCaseId(item.getParentProcessInstanceId());
        result.setProcessId(item.getProcessDefinitionId());
        result.setState(item.getState());
        result.setType(item.getType().name());
        result.setRootContainerId(item.getRootContainerId());
        result.setExecutedBySubstituteUserId(item.getExecutedBySubstitute());
        return result;
    }

    protected ProcessAPI getProcessAPI() {
        try {
            return TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    protected CONSOLE_ITEM convertEngineToConsoleItem(ENGINE_ITEM item) {
        return (CONSOLE_ITEM)FlowNodeConverter.convertEngineToConsoleItem(item);
    }

    public long count(String search, String orders, Map<String, String> filters) {
        return this.search(0, 0, search, orders, filters).getTotal();
    }

    @Override
    public CONSOLE_ITEM get(APIID id) {
        try {
            FlowNodeInstance flowNodeInstance = this.getProcessAPI().getFlowNodeInstance(id.toLong().longValue());
            return this.convertEngineToConsoleItem((ENGINE_ITEM)flowNodeInstance);
        }
        catch (NotFoundException e) {
            throw new APIItemNotFoundException("flownode", id);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ItemSearchResult<CONSOLE_ITEM> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsBuilder builder = this.makeSearchOptionBuilder(page, resultsByPage, search, orders, filters);
        SearchResult<ENGINE_ITEM> results = this.runSearch(builder, filters);
        return new ItemSearchResult(page, resultsByPage, results.getCount(), this.convertEngineToConsoleItemsList(results.getResult()));
    }

    protected SearchResult<ENGINE_ITEM> runSearch(SearchOptionsBuilder builder, Map<String, String> filters) {
        try {
            return this.getProcessAPI().searchFlowNodeInstances(builder.done());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    protected SearchOptionsBuilder makeSearchOptionBuilder(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsBuilder builder = SearchOptionsBuilderUtil.buildSearchOptions(page, resultsByPage, orders, search);
        this.addStringFilterToSearchBuilder(filters, builder, "caseId", "rootProcessInstanceId");
        this.addStringFilterToSearchBuilder(filters, builder, "rootCaseId", "rootProcessInstanceId");
        this.addStringFilterToSearchBuilder(filters, builder, "parentCaseId", "parentProcessInstanceId");
        this.addStringFilterToSearchBuilder(filters, builder, "parentActivityInstanceId", "parentActivityInstanceId");
        this.addStringFilterToSearchBuilder(filters, builder, "processId", "processDefinitionId");
        this.addStringFilterToSearchBuilder(filters, builder, "last_update_date", "lastUpdateDate");
        this.addStringFilterToSearchBuilder(filters, builder, "name", "name");
        if (filters.containsKey("state") && "pending".equalsIgnoreCase(filters.get("state"))) {
            builder.leftParenthesis().filter("state", (Serializable)((Object)"ready")).or().filter("state", (Serializable)((Object)"waiting")).rightParenthesis();
        } else if (filters.containsKey("state") && "ongoing".equalsIgnoreCase(filters.get("state"))) {
            builder.leftParenthesis().filter("state", (Serializable)((Object)"executing")).or().filter("state", (Serializable)((Object)"completing")).or().filter("state", (Serializable)((Object)"initializing")).rightParenthesis();
        } else {
            this.addStringFilterToSearchBuilder(filters, builder, "state", "state");
        }
        builder.differentFrom("state", (Serializable)((Object)"aborted"));
        builder.differentFrom("state", (Serializable)((Object)"cancelled"));
        builder.differentFrom("state", (Serializable)((Object)"completed"));
        return builder;
    }

    public AbstractFlowNodeDatastore<CONSOLE_ITEM, ENGINE_ITEM> setUpdateHelper(DatastoreHasUpdate<FlowNodeItem> updateHelper) {
        this.updateHelper = updateHelper;
        return this;
    }

    @Override
    public CONSOLE_ITEM update(APIID id, Map<String, String> attributes) {
        if (this.updateHelper != null) {
            return (CONSOLE_ITEM)this.updateHelper.update(id, attributes);
        }
        throw new APIMethodNotAllowedException("PUT method not allowed");
    }
}

