/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.bonitasoft.console.common.server.page.CustomPageService;
import org.bonitasoft.console.common.server.utils.BPMEngineException;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.console.common.server.utils.FormsResourcesUtils;
import org.bonitasoft.console.common.server.utils.PlatformManagementUtils;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveFactory;
import org.bonitasoft.engine.bpm.bar.InvalidBusinessArchiveFormatException;
import org.bonitasoft.engine.bpm.process.ProcessDefinition;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfo;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfoUpdater;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.io.FileContent;
import org.bonitasoft.engine.page.Page;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.process.ProcessItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.process.helper.ProcessItemConverter;
import org.bonitasoft.web.rest.server.datastore.bpm.process.helper.SearchProcessHelper;
import org.bonitasoft.web.rest.server.engineclient.EngineAPIAccessor;
import org.bonitasoft.web.rest.server.engineclient.EngineClientFactory;
import org.bonitasoft.web.rest.server.engineclient.ProcessEngineClient;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDatastore
extends CommonDatastore<ProcessItem, ProcessDeploymentInfo>
implements DatastoreHasAdd<ProcessItem>,
DatastoreHasUpdate<ProcessItem>,
DatastoreHasGet<ProcessItem>,
DatastoreHasSearch<ProcessItem>,
DatastoreHasDelete {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ProcessDatastore.class.getName());
    private static final String FILE_UPLOAD = "fileupload";
    private static final int DELETE_PAGES_BUNCH_SIZE = 100;

    public ProcessDatastore(APISession engineSession) {
        super(engineSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated(since="9.0.0")
    public ProcessItem add(ProcessItem process) {
        FileContent processFile;
        ProcessEngineClient engineClient = this.getProcessEngineClient();
        try {
            processFile = this.getTenantFolder().retrieveUploadedTempContent(process.getAttributes().get(FILE_UPLOAD));
        }
        catch (BonitaException e) {
            throw new APIException("Process file not found", (Throwable)e);
        }
        try {
            BusinessArchive businessArchive = this.readBusinessArchive(processFile.getInputStream());
            ProcessDefinition deployedArchive = engineClient.deploy(businessArchive);
            ProcessDeploymentInfo processDeploymentInfo = engineClient.getProcessDeploymentInfo(deployedArchive.getId());
            try {
                FormsResourcesUtils.retrieveApplicationFiles(this.getEngineSession(), processDeploymentInfo.getProcessId(), processDeploymentInfo.getDeploymentDate());
            }
            catch (IOException | BPMEngineException | ProcessDefinitionNotFoundException e) {
                throw new APIException("", e);
            }
            ProcessItem processItem = this.convertEngineToConsoleItem(processDeploymentInfo);
            return processItem;
        }
        finally {
            this.getTenantFolder().removeUploadedTempContent(process.getAttributes().get(FILE_UPLOAD));
        }
    }

    protected BonitaHomeFolderAccessor getTenantFolder() {
        return new BonitaHomeFolderAccessor();
    }

    protected BusinessArchive readBusinessArchive(InputStream inputStream) {
        try {
            return BusinessArchiveFactory.readBusinessArchive((InputStream)inputStream);
        }
        catch (IOException | InvalidBusinessArchiveFormatException e) {
            throw new APIException(e);
        }
    }

    @Override
    @Deprecated(since="9.0.0")
    public ProcessItem update(APIID id, Map<String, String> attributes) {
        ProcessDeploymentInfoUpdater updater = new ProcessDeploymentInfoUpdater();
        ProcessEngineClient engineClient = this.getProcessEngineClient();
        if (attributes.containsKey("displayDescription")) {
            updater.setDisplayDescription(attributes.get("displayDescription"));
        }
        if (attributes.containsKey("displayName")) {
            updater.setDisplayName(attributes.get("displayName"));
        }
        if (attributes.containsKey("activationState")) {
            this.changeProcessState(engineClient, id.toLong(), attributes.get("activationState"));
        }
        if (!updater.getFields().isEmpty()) {
            ProcessDeploymentInfo processDeploymentInfo = engineClient.updateProcessDeploymentInfo(id.toLong(), updater);
            return this.convertEngineToConsoleItem(processDeploymentInfo);
        }
        return this.convertEngineToConsoleItem(engineClient.getProcessDeploymentInfo(id.toLong()));
    }

    private void changeProcessState(ProcessEngineClient engineClient, Long processId, String state) {
        if ("DISABLED".equals(state)) {
            engineClient.disableProcess(processId);
        } else if ("ENABLED".equals(state)) {
            engineClient.enableProcess(processId);
        }
    }

    protected PlatformManagementUtils getPlatformManagementUtils() {
        return new PlatformManagementUtils();
    }

    @Override
    public ProcessItem get(APIID id) {
        ProcessEngineClient engineClient = this.getProcessEngineClient();
        ProcessDeploymentInfo processDeploymentInfo = engineClient.getProcessDeploymentInfo(id.toLong());
        return this.convertEngineToConsoleItem(processDeploymentInfo);
    }

    @Override
    public void delete(List<APIID> ids) {
        for (APIID id : ids) {
            this.removeProcessPagesFromHome(id);
            FormsResourcesUtils.removeApplicationFiles(this.getEngineSession(), id.toLong());
        }
        ProcessEngineClient engineClient = this.getProcessEngineClient();
        engineClient.deleteDisabledProcesses(APIID.toLongList(ids));
    }

    protected void removeProcessPagesFromHome(APIID id) {
        block5: {
            try {
                int startIndex = 0;
                int count = 0;
                do {
                    SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(startIndex, 100);
                    searchOptionsBuilder.filter("processDefinitionId", (Serializable)id.toLong());
                    SearchResult result = this.getPageAPI().searchPages(searchOptionsBuilder.done());
                    if (count == 0) {
                        count = (int)result.getCount();
                    }
                    startIndex += result.getResult().size();
                    for (Page page : result.getResult()) {
                        this.getCustomPageService().removePageLocally(page);
                    }
                } while (startIndex < count);
            }
            catch (IOException | BonitaException e) {
                if (!LOGGER.isWarnEnabled()) break block5;
                LOGGER.warn("Error when deleting pages for process with ID " + id, e);
            }
        }
    }

    protected CustomPageService getCustomPageService() {
        return new CustomPageService();
    }

    protected PageAPI getPageAPI() {
        try {
            return TenantAPIAccessor.getCustomPageAPI((APISession)this.getEngineSession());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ItemSearchResult<ProcessItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        ProcessEngineClient engineClient = this.getProcessEngineClient();
        return new SearchProcessHelper(engineClient).search(page, resultsByPage, search, orders, filters);
    }

    @Override
    protected ProcessItem convertEngineToConsoleItem(ProcessDeploymentInfo item) {
        if (item != null) {
            return new ProcessItemConverter(this.getProcessEngineClient().getProcessApi()).convert(item);
        }
        return null;
    }

    protected ProcessEngineClient getProcessEngineClient() {
        return this.getEngineClientFactory().createProcessEngineClient();
    }

    private EngineClientFactory getEngineClientFactory() {
        return new EngineClientFactory(new EngineAPIAccessor(this.getEngineSession()));
    }
}

