/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bonitasoft.web.rest.server.datastore.converter.StringValueConverter;
import org.bonitasoft.web.rest.server.datastore.filter.Field;
import org.bonitasoft.web.rest.server.datastore.filter.Filter;
import org.bonitasoft.web.rest.server.datastore.filter.FilterCreator;
import org.bonitasoft.web.rest.server.datastore.filter.Value;

public class Filters {
    private final List<Filter<?>> filters = new ArrayList();

    public Filters(Map<String, String> filters, FilterCreator filterCreator) {
        if (filters != null) {
            this.addFilters(filters, filterCreator);
        }
    }

    public Filters(Map<String, String> filters) {
        if (filters != null) {
            for (Map.Entry<String, String> filterEntry : filters.entrySet()) {
                Field field = new Field(filterEntry.getKey());
                Value<String> fieldValue = new Value<String>(filterEntry.getValue(), new StringValueConverter());
                Filter<String> filter = new Filter<String>(field, fieldValue);
                this.filters.add(filter);
            }
        }
    }

    private void addFilters(Map<String, String> filters, FilterCreator filterCreator) {
        Iterator<Map.Entry<String, String>> it = filters.entrySet().iterator();
        while (it.hasNext()) {
            this.addEntry(it.next(), filterCreator);
        }
    }

    private void addEntry(Map.Entry<String, String> entry, FilterCreator filterCreator) {
        this.filters.add(this.createFilter(filterCreator, entry));
    }

    private Filter<?> createFilter(FilterCreator filterCreator, Map.Entry<String, String> entry) {
        return filterCreator.create(entry.getKey(), entry.getValue());
    }

    public List<Filter<?>> asList() {
        return this.filters;
    }
}

