/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.organization;

import java.util.Map;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.console.common.server.utils.IconDescriptor;
import org.bonitasoft.engine.identity.GroupUpdater;
import org.bonitasoft.web.rest.server.engineclient.GroupEngineClient;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;

public class GroupUpdaterConverter {
    private final GroupEngineClient groupEngineClient;

    public GroupUpdaterConverter(GroupEngineClient groupEngineClient) {
        this.groupEngineClient = groupEngineClient;
    }

    public GroupUpdater convert(Map<String, String> attributes) {
        GroupUpdater updater = new GroupUpdater();
        if (attributes.containsKey("description")) {
            updater.updateDescription(attributes.get("description"));
        }
        if (!MapUtil.isBlank(attributes, "icon")) {
            IconDescriptor iconDescriptor = this.getBonitaHomeFolderAccessor().getIconFromFileSystem(attributes.get("icon"));
            updater.updateIcon(iconDescriptor.getFilename(), iconDescriptor.getContent());
        }
        if (!MapUtil.isBlank(attributes, "name")) {
            updater.updateName(attributes.get("name"));
        }
        if (attributes.containsKey("displayName")) {
            updater.updateDisplayName(attributes.get("displayName"));
        }
        if (attributes.containsKey("parent_group_id")) {
            String parentGroupPath = this.getParentGroupPath(attributes.get("parent_group_id"));
            updater.updateParentPath(parentGroupPath);
        }
        return updater;
    }

    BonitaHomeFolderAccessor getBonitaHomeFolderAccessor() {
        return new BonitaHomeFolderAccessor();
    }

    private String getParentGroupPath(String groupId) {
        if (groupId.isEmpty()) {
            return "";
        }
        return this.groupEngineClient.getPath(groupId);
    }
}

