/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.utils;

import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.web.rest.server.datastore.filter.Filter;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.utils.Sort;
import org.bonitasoft.web.rest.server.datastore.utils.Sorts;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;

public class SearchOptionsCreator {
    private final SearchOptionsBuilder builder;

    public SearchOptionsCreator(int page, int resultsByPage, String search, Sorts sorts, Filters filters) {
        this.builder = new SearchOptionsBuilder(SearchOptionsBuilderUtil.computeIndex(page, resultsByPage), resultsByPage);
        this.builder.searchTerm(search);
        this.addSorts(this.builder, sorts);
        this.addFilters(this.builder, filters);
    }

    private void addSorts(SearchOptionsBuilder builder, Sorts sorts) {
        for (Sort sort : sorts.asList()) {
            builder.sort(sort.getField(), sort.getOrder());
        }
    }

    private void addFilters(SearchOptionsBuilder builder, Filters filters) {
        for (Filter<?> filter : filters.asList()) {
            this.addFilter(builder, filter);
        }
    }

    private void addFilter(SearchOptionsBuilder builder, Filter<?> filter) {
        if (!StringUtil.isBlank(filter.getField())) {
            if (filter.getOperator() == Filter.Operator.DIFFERENT_FROM) {
                builder.differentFrom(filter.getField(), filter.getValue());
            } else {
                builder.filter(filter.getField(), filter.getValue());
            }
        }
    }

    public SearchOptions create() {
        return this.builder.done();
    }

    public SearchOptionsBuilder getBuilder() {
        return this.builder;
    }
}

