/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.engineclient;

import java.io.Serializable;
import java.util.HashMap;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.data.DataInstance;
import org.bonitasoft.engine.bpm.data.DataNotFoundException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APINotFoundException;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;

public class ActivityEngineClient {
    private final ProcessAPI processAPI;

    public ActivityEngineClient(ProcessAPI processAPI) {
        this.processAPI = processAPI;
    }

    public long countFailedActivities() {
        SearchOptions search = new SearchOptionsBuilder(0, 0).filter("state", (Serializable)((Object)"failed")).done();
        try {
            return this.processAPI.searchActivities(search).getCount();
        }
        catch (SearchException e) {
            throw new APIException("Error when counting failed activities", (Throwable)e);
        }
    }

    public DataInstance getDataInstance(String dataName, long activityId) {
        try {
            return this.processAPI.getActivityDataInstance(dataName, activityId);
        }
        catch (DataNotFoundException e) {
            throw new APINotFoundException(new T_("Unable to find data instance %dataName% for activity %activityId%", new Arg("dataName", dataName), new Arg("activityId", activityId)), (Throwable)e);
        }
    }

    public void updateVariables(long activityId, HashMap<String, Serializable> variables) {
        try {
            this.processAPI.updateActivityInstanceVariables(activityId, variables);
        }
        catch (UpdateException e) {
            throw new APIException(new T_("Error when updating %activityId% activity variables", new Arg("activityId", activityId)), (Throwable)e);
        }
    }
}

