/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.engineclient;

import org.bonitasoft.engine.api.GroupAPI;
import org.bonitasoft.engine.api.IdentityAPI;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.ProfileAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.api.TenantAdministrationAPI;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;

public class EngineAPIAccessor {
    private final APISession session;

    public EngineAPIAccessor(APISession session) {
        this.session = session;
    }

    public APISession getSession() {
        return this.session;
    }

    public ProfileAPI getProfileAPI() {
        try {
            return TenantAPIAccessor.getProfileAPI((APISession)this.getSession());
        }
        catch (BonitaException e) {
            throw new APIException("Error when getting engine process API", (Throwable)e);
        }
    }

    public ProcessAPI getProcessAPI() {
        try {
            return TenantAPIAccessor.getProcessAPI((APISession)this.getSession());
        }
        catch (BonitaException e) {
            throw new APIException("Error when getting engine process API", (Throwable)e);
        }
    }

    public IdentityAPI getIdentityAPI() {
        try {
            return TenantAPIAccessor.getIdentityAPI((APISession)this.getSession());
        }
        catch (BonitaException e) {
            throw new APIException("Error when getting engine identity API", (Throwable)e);
        }
    }

    public GroupAPI getGroupAPI() {
        try {
            return TenantAPIAccessor.getIdentityAPI((APISession)this.getSession());
        }
        catch (BonitaException e) {
            throw new APIException("Error when getting engine group API", (Throwable)e);
        }
    }

    public PageAPI getPageAPI() {
        try {
            return TenantAPIAccessor.getCustomPageAPI((APISession)this.getSession());
        }
        catch (BonitaException e) {
            throw new APIException("Error when getting engine page API", (Throwable)e);
        }
    }

    public TenantAdministrationAPI getTenantAdministrationAPI() {
        try {
            return TenantAPIAccessor.getTenantAdministrationAPI((APISession)this.getSession());
        }
        catch (BonitaException e) {
            throw new APIException("Error when getting engine tenant management API", (Throwable)e);
        }
    }
}

