/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.engineclient;

import org.bonitasoft.engine.api.ProfileAPI;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.profile.ProfileMember;
import org.bonitasoft.engine.profile.ProfileMemberNotFoundException;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIForbiddenException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;

public class ProfileMemberEngineClient {
    private final ProfileAPI profileApi;

    protected ProfileMemberEngineClient(ProfileAPI profileApi) {
        this.profileApi = profileApi;
    }

    public SearchResult<ProfileMember> searchProfileMembers(String memberType, SearchOptions searchOptions) {
        try {
            return this.profileApi.searchProfileMembers(memberType, searchOptions);
        }
        catch (SearchException e) {
            throw new APIException(e);
        }
    }

    public ProfileMember createProfileMember(Long profileId, Long userId, Long groupId, Long roleId) {
        try {
            return this.profileApi.createProfileMember(profileId, userId, groupId, roleId);
        }
        catch (AlreadyExistsException e) {
            throw new APIForbiddenException(new T_("Profile member already exists"), (Throwable)e);
        }
        catch (CreationException e) {
            throw new APIException(e);
        }
    }

    public void deleteProfileMember(Long id) {
        try {
            this.profileApi.deleteProfileMember(id);
        }
        catch (DeletionException e) {
            if (e.getCause() instanceof ProfileMemberNotFoundException) {
                throw new APIItemNotFoundException("memberProfile");
            }
            throw new APIException(e);
        }
    }
}

