/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.framework;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.bonitasoft.web.rest.server.framework.APIServletCall;
import org.bonitasoft.web.rest.server.framework.Deployer;
import org.bonitasoft.web.rest.server.framework.api.Datastore;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.rest.server.framework.exception.ForbiddenAttributesException;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIMethodNotAllowedException;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.IItem;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class API<ITEM extends IItem> {
    protected ItemDefinition<ITEM> itemDefinition = null;
    private final Map<String, Deployer> deployers = new HashMap<String, Deployer>();
    private static Logger LOGGER = LoggerFactory.getLogger((String)API.class.getName());
    private APIServletCall caller = null;

    public API() {
        this.itemDefinition = this.defineItemDefinition();
    }

    public final void setCaller(APIServletCall caller) {
        this.caller = caller;
    }

    public final ItemDefinition<ITEM> getItemDefinition() {
        return this.itemDefinition;
    }

    protected ItemDefinition<ITEM> defineItemDefinition() {
        return null;
    }

    protected final HttpSession getHttpSession() {
        return this.caller.getHttpSession();
    }

    protected String getLocale() {
        return this.caller.getLocale();
    }

    public ITEM runAdd(IItem item) {
        this.checkForbiddenAttributes(item.getAttributes());
        return (ITEM)this.add(item);
    }

    public ITEM add(ITEM item) {
        Datastore datastore = this.getDefaultDatastore();
        if (!(datastore instanceof DatastoreHasAdd)) {
            throw new APIMethodNotAllowedException("POST method not allowed.");
        }
        return ((DatastoreHasAdd)((Object)datastore)).add(item);
    }

    public ITEM runUpdate(APIID id, Map<String, String> attributes) {
        id.setItemDefinition(this.getItemDefinition());
        this.checkForbiddenAttributes(attributes);
        return this.update(id, attributes);
    }

    public ITEM update(APIID id, Map<String, String> attributes) {
        Datastore datastore = this.getDefaultDatastore();
        if (datastore == null || !(datastore instanceof DatastoreHasUpdate)) {
            throw new APIMethodNotAllowedException("PUT method not allowed.");
        }
        return (ITEM)((DatastoreHasUpdate)((Object)datastore)).update(id, attributes);
    }

    public ITEM runGet(APIID id, List<String> deploys, List<String> counters) {
        id.setItemDefinition(this.getItemDefinition());
        ITEM item = this.get(id);
        if (item == null) {
            throw new APIItemNotFoundException(this.getItemDefinition().getToken(), id);
        }
        this.fillDeploys(item, deploys != null ? deploys : new ArrayList());
        this.fillCounters(item, counters != null ? counters : new ArrayList());
        return item;
    }

    public ITEM get(APIID id) {
        Datastore datastore = this.getDefaultDatastore();
        if (datastore == null || !(datastore instanceof DatastoreHasGet)) {
            throw new APIMethodNotAllowedException("GET method not allowed.");
        }
        return (ITEM)((DatastoreHasGet)((Object)datastore)).get(id);
    }

    public ItemSearchResult<ITEM> runSearch(int page, int resultsByPage, String search, String orders, Map<String, String> filters, List<String> deploys, List<String> counters) {
        String realOrders = orders;
        if ((orders == null || orders.length() == 0) && (realOrders = this.defineDefaultSearchOrder()) == null) {
            throw new APIException("No default search order defined. Please, override the defineDefaultSearchOrder method in " + this.getClass().toString() + ".");
        }
        ItemSearchResult<ITEM> searchResult = this.search(page, resultsByPage, search, realOrders, filters != null ? filters : new HashMap());
        for (IItem item : searchResult.getResults()) {
            this.fillDeploys(item, deploys != null ? deploys : new ArrayList());
            this.fillCounters(item, counters != null ? counters : new ArrayList());
        }
        return searchResult;
    }

    public ItemSearchResult<ITEM> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        Datastore datastore = this.getDefaultDatastore();
        if (datastore == null || !(datastore instanceof DatastoreHasSearch)) {
            throw new APIMethodNotAllowedException("SEARCH method not allowed.");
        }
        return ((DatastoreHasSearch)((Object)datastore)).search(page, resultsByPage, search, orders, filters);
    }

    public String defineDefaultSearchOrder() {
        return null;
    }

    public void runDelete(List<APIID> ids) {
        for (APIID id : ids) {
            id.setItemDefinition(this.getItemDefinition());
        }
        this.delete(ids);
    }

    public void delete(List<APIID> ids) {
        Datastore datastore = this.getDefaultDatastore();
        if (datastore == null || !(datastore instanceof DatastoreHasDelete)) {
            throw new APIMethodNotAllowedException("DELETE method not allowed.");
        }
        ((DatastoreHasDelete)((Object)datastore)).delete(ids);
    }

    protected Datastore defineDefaultDatastore() {
        return null;
    }

    public final Datastore getDefaultDatastore() {
        return this.defineDefaultDatastore();
    }

    public void addDeployer(Deployer deployer) {
        this.deployers.put(deployer.getDeployedAttribute(), deployer);
    }

    public Map<String, Deployer> getDeployers() {
        return Collections.unmodifiableMap(this.deployers);
    }

    protected void fillDeploys(ITEM item, List<String> deploys) {
        for (String attribute : deploys) {
            this.deployAttribute(attribute, item);
        }
    }

    private void deployAttribute(String attribute, ITEM item) {
        block4: {
            if (this.deployers.containsKey(attribute)) {
                try {
                    this.deployers.get(attribute).deployIn((IItem)item);
                }
                catch (Exception e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(this.getFailedDeployMessage(attribute, item), (Throwable)e);
                    }
                    if (!LOGGER.isInfoEnabled()) break block4;
                    LOGGER.info(this.getFailedDeployMessage(attribute, item));
                }
            }
        }
    }

    protected String getFailedDeployMessage(String attribute, ITEM item) {
        return "Could not deploy attribute '" + attribute + "' on item " + item.toString();
    }

    protected void fillCounters(ITEM item, List<String> counters) {
    }

    protected final boolean isDeployable(String attributeName, List<String> deploys, IItem item) {
        String attributeValue = item.getAttributeValue(attributeName);
        if (deploys.contains(attributeName) && attributeValue != null && !attributeValue.isEmpty()) {
            try {
                long longAttrValue = Long.parseLong(attributeValue);
                return longAttrValue > 0L;
            }
            catch (NumberFormatException e) {
                return true;
            }
        }
        return false;
    }

    protected List<String> defineReadOnlyAttributes() {
        return null;
    }

    private void checkForbiddenAttributes(Map<String, String> attributes) {
        ArrayList<String> forbiddenAttributes = new ArrayList<String>();
        List<String> definedForbiddenAttributes = this.defineReadOnlyAttributes();
        if (definedForbiddenAttributes != null) {
            forbiddenAttributes.addAll(definedForbiddenAttributes);
        }
        if (forbiddenAttributes.size() == 0) {
            return;
        }
        ArrayList<String> errorAttributes = new ArrayList<String>();
        for (String forbiddenAttribute : forbiddenAttributes) {
            if (MapUtil.isBlank(attributes, forbiddenAttribute)) continue;
            errorAttributes.add(forbiddenAttribute);
        }
        if (errorAttributes.size() > 0) {
            throw new ForbiddenAttributesException(errorAttributes);
        }
    }
}

