/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.common.util;

import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;

public class MapUtil {
    public static String getValue(Map<String, String> map, String key, String defaultValue) {
        if (!map.containsKey(key)) {
            return defaultValue;
        }
        return map.get(key);
    }

    public static Long getValueAsLong(Map<String, String> map, String key) throws NumberFormatException {
        String value = map.get(key);
        if (StringUtil.isBlank(value)) {
            return null;
        }
        return Long.valueOf(value);
    }

    public static Boolean getValueAsBoolean(Map<String, String> map, String key) throws IllegalArgumentException {
        String value = map.get(key);
        if (StringUtil.isBlank(value)) {
            return null;
        }
        return StringUtil.toBoolean(value);
    }

    public static boolean isBlank(Map<String, String> map, String key) {
        return !map.containsKey(key) || StringUtil.isBlank(map.get(key));
    }

    public static boolean removeIfBlank(Map<String, String> map, String key) {
        if (MapUtil.isBlank(map, key)) {
            map.remove(key);
            return true;
        }
        return false;
    }

    public static Map<String, String> asMap(Arg ... args) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (Arg arg : args) {
            results.put(arg.getName(), arg.getValue());
        }
        return results;
    }

    public static <K, V> void iterate(Map<K, V> map, ForEach<K, V> modifier) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            modifier.apply(entry.getKey(), entry.getValue());
        }
    }

    public static String getMandatory(Map<String, String> map, String key) {
        String value = map.get(key);
        if (value == null) {
            throw new RuntimeException("Can't find value corresponding to " + key);
        }
        return value;
    }

    public static abstract class ForEach<K, V> {
        protected abstract void apply(K var1, V var2);
    }
}

