/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.data.item;

import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.web.toolkit.client.ItemDefinitionFactory;
import org.bonitasoft.web.toolkit.client.data.item.DummyItemDefinition;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class Definitions {
    private final Map<String, ItemDefinition<?>> itemDefinitions = new HashMap();
    private static final Definitions INSTANCE = new Definitions();

    public static Definitions getInstance() {
        return INSTANCE;
    }

    public static ItemDefinition<?> get(String token) {
        return Definitions.getInstance().getDefinition(token);
    }

    public final ItemDefinition<?> getDefinition(String token) {
        if (this.itemDefinitions.containsKey(token)) {
            return this.itemDefinitions.get(token);
        }
        if ("dummy".equals(token)) {
            return new DummyItemDefinition();
        }
        ItemDefinition<?> itemDefinition = ItemDefinitionFactory.getDefaultFactory().defineItemDefinitions(token);
        if (itemDefinition != null) {
            this.itemDefinitions.put(token, itemDefinition);
            return itemDefinition;
        }
        return null;
    }
}

