/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.data.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.Definitions;
import org.bonitasoft.web.toolkit.client.data.item.IItem;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ItemAttribute;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ValidationException;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.Validator;

public abstract class ItemDefinition<E extends IItem> {
    private String token = null;
    private String APIUrl = null;
    private final LinkedHashMap<String, ItemAttribute> attributes = new LinkedHashMap();
    private final ArrayList<String> primaryKeys = new ArrayList();
    private final Map<String, ItemDefinition<?>> deploys = new HashMap();

    public ItemDefinition() {
        this.setToken(this.defineToken());
        this.defineAttributes();
        this.setAPIUrl(this.defineAPIUrl());
        this.definePrimaryKeys();
        this.defineDeploys();
    }

    protected abstract String defineToken();

    public final void setToken(String token) {
        this.token = token;
    }

    public final String getToken() {
        return this.token;
    }

    public final String getAPIUrl() {
        return this.APIUrl;
    }

    protected final void setAPIUrl(String url) {
        this.APIUrl = url;
    }

    protected abstract String defineAPIUrl();

    public ItemAttribute createAttribute(String name, ItemAttribute.TYPE type) {
        ItemAttribute attribute = new ItemAttribute(name, type);
        this.attributes.put(name, attribute);
        return attribute;
    }

    protected abstract void defineAttributes();

    public final ArrayList<ItemAttribute> getAttributes() {
        return new ArrayList<ItemAttribute>(this.attributes.values());
    }

    protected abstract void definePrimaryKeys();

    protected final void setPrimaryKeys(String ... primaryKeys) {
        this.primaryKeys.clear();
        for (String key : primaryKeys) {
            this.primaryKeys.add(key);
            if (this.attributes.containsKey(key)) continue;
            this.createAttribute(key, ItemAttribute.TYPE.ITEM_ID);
        }
    }

    public final ArrayList<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public final ItemAttribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    public final boolean containsAttribute(String attributeName) {
        return this.attributes.containsKey(attributeName);
    }

    protected void defineDeploys() {
    }

    protected final void declareDeployable(String attributeName, ItemDefinition<?> definition) {
        this.deploys.put(attributeName, definition);
    }

    public final ItemDefinition<?> getDeployDefinition(String attributeName) {
        return this.deploys.containsKey(attributeName) ? this.deploys.get(attributeName) : Definitions.get("dummy");
    }

    public final Map<String, List<Validator>> getValidators() {
        HashMap<String, List<Validator>> validators = new HashMap<String, List<Validator>>();
        for (ItemAttribute attribute : this.getAttributes()) {
            validators.put(attribute.getName(), attribute.getValidators());
        }
        return validators;
    }

    protected abstract E _createItem();

    public final E createItem() {
        try {
            return this.createItem((Map<String, String>)null);
        }
        catch (ValidationException e) {
            return null;
        }
    }

    public final E createItem(Map<String, String> attributes) throws ValidationException {
        E item = this._createItem();
        if (attributes != null) {
            item.setAttributes(attributes);
        }
        return item;
    }

    public final E createItem(IItem sourceItem) {
        return sourceItem == null ? null : (E)this.createItem(sourceItem.getAttributes());
    }

    public final APIID makeAPIID(String ... id) {
        return this.makeAPIID(Arrays.asList(id));
    }

    public final APIID makeAPIID(Long ... ids) {
        APIID apiid = APIID.makeAPIID(ids);
        apiid.setItemDefinition(this);
        return apiid;
    }

    public final APIID makeAPIID(List<String> ids) {
        APIID apiid = APIID.makeAPIID(ids);
        apiid.setItemDefinition(this);
        return apiid;
    }
}

