/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.data.item.attribute.validator;

import org.bonitasoft.web.toolkit.client.common.i18n.AbstractI18n;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.AbstractStringValidator;

public class StringMaxLengthValidator
extends AbstractStringValidator {
    private final Integer maxLength;
    private final Boolean includeMax;

    public StringMaxLengthValidator(Integer maxLength) {
        this(maxLength, true);
    }

    public StringMaxLengthValidator(Integer maxLength, Boolean includeMax) {
        this.maxLength = maxLength;
        this.includeMax = includeMax;
    }

    @Override
    protected void _check(String attributeValue) {
        int length = attributeValue.length();
        if (this.includeMax.booleanValue()) {
            if (this.maxLength != null && length > this.maxLength) {
                this.addError(AbstractI18n.t_("%attribute% must be less or equal than %value%", new Arg("value", this.maxLength)));
            }
        } else if (this.maxLength != null && length >= this.maxLength) {
            this.addError(AbstractI18n.t_("%attribute% must be less than %value%", new Arg("value", this.maxLength)));
        }
    }
}

