/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.ui.utils;

import java.util.List;

public class ListUtils {
    public static void removeFromListByClass(List<?> list, String className) {
        ListUtils.removeFromListByClass(list, className, false);
    }

    public static void removeFromListByClass(List<?> list, String className, boolean firstOnly) {
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (!o.getClass().getName().equals(className)) continue;
            list.remove(i);
            if (firstOnly) {
                return;
            }
            --i;
        }
    }

    public static Object getFromListByClass(List<?> list, String className) {
        for (Object o : list) {
            if (!o.getClass().getName().equals(className)) continue;
            return o;
        }
        return null;
    }

    public static String join(List<?> list, String separator) {
        return ListUtils.join(list, separator, separator, "", "");
    }

    public static String join(List<?> list, String separator, String lastSeparator, String itemPrefix, String itemSuffix) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            if (item == null) continue;
            if (i == list.size() - 1 && list.size() > 1) {
                result.append(lastSeparator);
            } else if (i > 0) {
                result.append(separator);
            }
            if (itemPrefix != null) {
                result.append(itemPrefix);
            }
            result.append(item);
            if (itemSuffix == null) continue;
            result.append(itemSuffix);
        }
        return result.toString();
    }
}

