/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.console.common.server.utils.LocaleUtils;
import org.bonitasoft.web.toolkit.client.common.exception.http.ServerException;
import org.bonitasoft.web.toolkit.client.common.json.JSonSerializer;

public abstract class ServletCall {
    private String inputStream = null;
    protected final Map<String, String[]> parameters = new HashMap<String, String[]>();
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private PrintWriter outputWriter = null;

    public ServletCall(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.parseRequest(request, response);
    }

    public ServletCall() {
        this.request = null;
        this.response = null;
    }

    public HttpSession getHttpSession() {
        return this.request.getSession();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public String getRequestURL() {
        return this.request.getRequestURL().toString();
    }

    public String getInputStream() {
        if (this.inputStream == null) {
            BufferedReader reader = null;
            try {
                ServletInputStream stream = this.request.getInputStream();
                reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
                StringBuilder sb = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    sb.append(line + "\n");
                    line = reader.readLine();
                }
                this.inputStream = sb.toString();
                this.closeQuietly(reader);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Can't read input Stream.", e);
                }
                catch (Throwable throwable) {
                    this.closeQuietly(reader);
                    throw throwable;
                }
            }
        }
        return this.inputStream;
    }

    private void closeQuietly(BufferedReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int countParameters() {
        return this.parameters.size();
    }

    public List<String> getParameterAsList(String name) {
        return this.getParameterAsList(name, null);
    }

    public List<String> getParameterAsList(String name, String defaultValue) {
        if (this.parameters.containsKey(name)) {
            return Arrays.asList(this.parameters.get(name));
        }
        if (defaultValue != null) {
            ArrayList<String> results = new ArrayList<String>();
            results.add(defaultValue);
            return results;
        }
        return null;
    }

    public String getParameter(String name) {
        return this.getParameter(name, null);
    }

    public String getParameter(String name, String defaultValue) {
        String[] result;
        if (this.parameters.containsKey(name) && (result = this.parameters.get(name)).length > 0) {
            return result[0];
        }
        return defaultValue;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    protected void head(String name, String value) {
        this.response.addHeader(name, value);
    }

    protected void output(File file) {
        try (FileInputStream stream = new FileInputStream(file);){
            this.output(stream);
        }
        catch (FileNotFoundException e) {
            throw new ServerException(e);
        }
        catch (IOException e) {
            throw new ServerException(e);
        }
    }

    protected void output(InputStream stream, String filename) {
        this.response.addHeader("Content-Disposition", "attachment; filename=" + filename + ";");
        this.output(stream);
    }

    protected void output(InputStream stream) {
        this.response.setContentType("application/octet-stream");
        try {
            IOUtils.copy((InputStream)stream, (OutputStream)this.response.getOutputStream());
        }
        catch (IOException e) {
            throw new ServerException(e);
        }
    }

    protected void output(String string) {
        PrintWriter outputWriter = this.getOutputWriter();
        outputWriter.print(string);
        outputWriter.flush();
    }

    protected void output(Object object) {
        PrintWriter outputWriter = this.getOutputWriter();
        outputWriter.print(JSonSerializer.serialize(object));
        outputWriter.flush();
    }

    private PrintWriter getOutputWriter() {
        if (this.outputWriter == null) {
            this.response.setContentType("application/json;charset=UTF-8");
            try {
                this.outputWriter = this.response.getWriter();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.outputWriter;
    }

    protected void parseRequest(HttpServletRequest request, HttpServletResponse response) {
        this.parameters.putAll(this.request.getParameterMap());
    }

    public String getLocale() {
        return LocaleUtils.getUserLocaleAsString(this.request);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public abstract void doGet() throws IOException;

    public abstract void doPost() throws IOException;

    public abstract void doPut() throws IOException;

    public abstract void doDelete() throws IOException;
}

