/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.bonitasoft.platform.configuration.impl.ConfigurationColumns;
import org.bonitasoft.platform.configuration.model.FullBonitaConfiguration;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.support.lob.TemporaryLobCreator;

public class BonitaAllConfigurationPreparedStatementSetter
implements BatchPreparedStatementSetter,
ConfigurationColumns {
    public static final String INSERT_CONFIGURATION = "INSERT into configuration(tenant_id, content_type, resource_name, resource_content) values (?,?,?,?)";
    private final List<FullBonitaConfiguration> bonitaConfigurations;
    String dbVendor;

    public BonitaAllConfigurationPreparedStatementSetter(List<FullBonitaConfiguration> bonitaConfigurations, String dbVendor) {
        this.bonitaConfigurations = bonitaConfigurations;
        this.dbVendor = dbVendor;
        if (this.dbVendor == null) {
            this.dbVendor = System.getProperty("sysprop.bonita.db.vendor");
        }
    }

    public void setValues(PreparedStatement ps, int i) throws SQLException {
        FullBonitaConfiguration bonitaConfiguration = this.bonitaConfigurations.get(i);
        ps.setLong(1, bonitaConfiguration.getTenantId());
        ps.setString(2, bonitaConfiguration.getConfigurationType());
        ps.setString(3, bonitaConfiguration.getResourceName());
        switch (this.dbVendor) {
            case "h2": 
            case "postgres": {
                ps.setBytes(4, bonitaConfiguration.getResourceContent());
                break;
            }
            case "oracle": 
            case "mysql": 
            case "sqlserver": {
                TemporaryLobCreator temporaryLobCreator = new TemporaryLobCreator();
                temporaryLobCreator.setBlobAsBytes(ps, 4, bonitaConfiguration.getResourceContent());
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported db vendor:" + this.dbVendor);
            }
        }
    }

    public int getBatchSize() {
        return this.bonitaConfigurations.size();
    }
}

